/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.ArmorPartPosition;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ArmorPartFrame;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.recipe.IngredientToolPart;
import net.silentchaos512.lib.collection.ItemStackList;
import net.silentchaos512.lib.recipe.RecipeBaseSL;
import net.silentchaos512.lib.util.StackHelper;

public class RecipeMixedMaterialItem
extends RecipeBaseSL {
    public static final char CHAR_HEAD_PART = 'h';
    public static final char CHAR_ROD_PART = 'r';
    public static final char CHAR_ARMOR_FRAME = 'f';
    final ShapedRecipes shapedRecipe;
    final Item toolItem;
    @Nullable
    final EnumMaterialTier tierRestriction;

    public RecipeMixedMaterialItem(@Nullable EnumMaterialTier tierRestriction, Item toolOrArmorItem, Object ... recipe) {
        this.tierRestriction = tierRestriction;
        this.toolItem = toolOrArmorItem;
        ArrayList<String> layout = new ArrayList<String>();
        int recipeWidth = 0;
        int recipeHeight = 0;
        int index = 0;
        while (index < recipe.length && recipe[index] instanceof String) {
            String str = (String)recipe[index++];
            layout.add(str);
            recipeWidth = str.length();
        }
        recipeHeight = layout.size();
        int recipeSize = recipeWidth * recipeHeight;
        HashMap<Character, Ingredient> itemMap = new HashMap<Character, Ingredient>();
        itemMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        itemMap.put(Character.valueOf('h'), new IngredientToolPart(ToolPartPosition.HEAD));
        itemMap.put(Character.valueOf('r'), new IngredientToolPart(ToolPartPosition.ROD));
        itemMap.put(Character.valueOf('f'), new IngredientToolPart(ArmorPartPosition.FRAME));
        while (index < recipe.length) {
            Character chr = (Character)recipe[index];
            if (chr.charValue() == 'h' || chr.charValue() == 'r' || chr.charValue() == ' ') {
                throw new IllegalArgumentException(chr + " is a reserved character.");
            }
            Object in = recipe[index + 1];
            Ingredient ing = CraftingHelper.getIngredient((Object)in);
            if (ing != null) {
                itemMap.put(chr, ing);
            }
            index += 2;
        }
        NonNullList ingredients = NonNullList.func_191197_a((int)recipeSize, (Object)Ingredient.field_193370_a);
        int x = 0;
        for (String str : layout) {
            for (char chr : str.toCharArray()) {
                Ingredient ing = (Ingredient)itemMap.get(Character.valueOf(chr));
                if (ing == null) continue;
                ingredients.set(x++, (Object)ing);
            }
        }
        this.shapedRecipe = new ShapedRecipes("silentgems", recipeWidth, recipeHeight, ingredients, new ItemStack(toolOrArmorItem));
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ArmorPartFrame frame;
        if (this.tierRestriction != null && !this.partTiersMatch(inv)) {
            return false;
        }
        ItemStack stackFrame = this.getFrame(inv);
        if (StackHelper.isValid((ItemStack)stackFrame) && !this.doesFrameMatchItem(frame = (ArmorPartFrame)ToolPartRegistry.fromStack(stackFrame))) {
            return false;
        }
        return this.shapedRecipe.func_77569_a(inv, world);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack(this.toolItem);
    }

    protected boolean partTiersMatch(InventoryCrafting inv) {
        ToolPart partFrame;
        EnumMaterialTier tier = null;
        for (ItemStack stack : this.getMaterials(inv)) {
            ToolPart part = ToolPartRegistry.fromStack(stack);
            if (tier == null) {
                tier = part.getTier();
                continue;
            }
            if (tier == part.getTier()) continue;
            return false;
        }
        if (tier == null) {
            return false;
        }
        if (this.tierRestriction != null && tier != this.tierRestriction) {
            return false;
        }
        ItemStack rod = this.getRod(inv);
        if (StackHelper.isValid((ItemStack)rod)) {
            return ToolPartRegistry.fromStack(rod).validForToolOfTier(tier);
        }
        ItemStack frame = this.getFrame(inv);
        if (StackHelper.isValid((ItemStack)frame) && (partFrame = ToolPartRegistry.fromStack(frame)) instanceof ArmorPartFrame) {
            return partFrame.validForToolOfTier(tier) && this.doesFrameMatchItem((ArmorPartFrame)partFrame);
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (!this.partTiersMatch(inv)) {
            return StackHelper.empty();
        }
        ItemStack rod = this.getRod(inv);
        ItemStack frame = this.getFrame(inv);
        ItemStackList materials = this.getMaterials(inv);
        ItemStack[] array = (ItemStack[])materials.toArray((Object[])new ItemStack[materials.size()]);
        if (this.toolItem instanceof ITool) {
            return ((ITool)this.toolItem).constructTool(rod, array);
        }
        if (this.toolItem instanceof IArmor) {
            return ((IArmor)this.toolItem).constructArmor(frame, array);
        }
        return StackHelper.empty();
    }

    protected ItemStackList getMaterials(InventoryCrafting inv) {
        ItemStackList list = ItemStackList.create();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            ToolPart part = ToolPartRegistry.fromStack(stack);
            if (part == null || part.isBlacklisted(stack) || !(part instanceof ToolPartMain)) continue;
            list.add((Object)stack);
        }
        return list;
    }

    protected ItemStack getRod(InventoryCrafting inv) {
        ItemStack rod = StackHelper.empty();
        for (ItemStack stack : RecipeMixedMaterialItem.getNonEmptyStacks((InventoryCrafting)inv)) {
            ToolPart part = ToolPartRegistry.fromStack(stack);
            if (part == null || part.isBlacklisted(stack) || !(part instanceof ToolPartRod)) continue;
            if (StackHelper.isEmpty((ItemStack)rod)) {
                rod = stack;
                continue;
            }
            if (rod.func_77969_a(stack)) continue;
            return StackHelper.empty();
        }
        return rod;
    }

    protected ItemStack getFrame(InventoryCrafting inv) {
        ItemStack frame = StackHelper.empty();
        for (ItemStack stack : RecipeMixedMaterialItem.getNonEmptyStacks((InventoryCrafting)inv)) {
            ToolPart part = ToolPartRegistry.fromStack(stack);
            if (part == null || !(part instanceof ArmorPartFrame)) continue;
            if (StackHelper.isEmpty((ItemStack)frame)) {
                frame = stack;
                continue;
            }
            if (frame.func_77969_a(stack)) continue;
            return StackHelper.empty();
        }
        return frame;
    }

    protected boolean doesFrameMatchItem(ArmorPartFrame frame) {
        if (!(this.toolItem instanceof ItemArmor)) {
            return true;
        }
        return frame.getSlot() == ((ItemArmor)this.toolItem).field_77881_a;
    }
}

