/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.module;

import java.util.Calendar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.Skulls;

public class ModuleHalloweenHijinks {
    public static ModuleHalloweenHijinks instance = new ModuleHalloweenHijinks();
    static final String NBT_MARKER = "SG_HW_Mob";
    Calendar today;
    boolean rightDay = this.checkDate();
    boolean moduleEnabled = true;
    boolean forcedOn = false;
    float costumeChance = 0.3f;
    float costumeDropRate = 0.01f;
    long ticksRunning = 0L;

    private boolean checkDate() {
        this.today = Calendar.getInstance();
        int month = this.today.get(2);
        int date = this.today.get(5);
        this.rightDay = month == 9 && date >= 28 && date <= 31;
        return this.rightDay;
    }

    public boolean isEnabled() {
        return this.moduleEnabled || this.forcedOn;
    }

    public void loadConfig(Configuration c) {
        String cat = "main.misc" + "." + "halloween_hijinks";
        c.setCategoryComment(cat, "Halloween event options. WARNING: This feature is known to cause some lag spikes, as it loads skins. The spikes may reduce in frequency as you play.");
        this.moduleEnabled = c.getBoolean("Enabled", cat, true, "Some mobs may dress up for the end of October.");
        this.forcedOn = c.getBoolean("Forced On", cat, false, "Halloween all year round! (See the warning in the category comment first).");
        this.costumeChance = c.getFloat("Costume Chance", cat, 0.3f, 0.0f, 1.0f, "The chance of a mob receiving a \"costume\".");
        this.costumeDropRate = c.getFloat("Costume Drop Rate", cat, 0.01f, 0.0f, 1.0f, "The chance that a mob will drop their \"costume\" when killed.");
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving;
        if (!(this.forcedOn || this.rightDay && this.moduleEnabled)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityLiving && entity instanceof IMob && !(entityLiving = event.getEntityLiving()).getEntityData().func_74767_n(NBT_MARKER)) {
            entityLiving.getEntityData().func_74757_a(NBT_MARKER, true);
            if (SilentGems.random.nextFloat() < this.costumeChance) {
                ItemStack skull = Skulls.selectRandom(SilentGems.random);
                entityLiving.func_184201_a(EntityEquipmentSlot.HEAD, skull);
                ((EntityLiving)entityLiving).func_184642_a(EntityEquipmentSlot.HEAD, this.costumeDropRate);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ++this.ticksRunning;
        if (this.ticksRunning % 6000L == 0L) {
            this.checkDate();
        }
    }

    @SubscribeEvent
    public void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        Skulls.putPlayer(event.player.func_70005_c_());
    }
}

