/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.module;

import java.util.Random;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.util.StackHelper;

public class ModuleCoffee {
    public static final String MODULE_NAME = "coffee";
    public static final String NBT_TIME_TO_NEXT_COFFEE = "SGTimeToNextCoffee";
    public static boolean MODULE_ENABLED = true;
    public static int INTERVAL_MIN = 9000;
    public static int INTERVAL_MAX = 18000;

    public static void loadConfig(Configuration c) {
        String cat = "main" + "." + MODULE_NAME;
        c.setCategoryComment(cat, "Configs for coffee drops. Where does coffee drop from, you ask? I have no idea :p. Note that coffee\ndrops will be disabled if the min and max intervals have nonsense values (see the comments for\nthose options).");
        MODULE_ENABLED = c.getBoolean("Enabled", cat, MODULE_ENABLED, "Enable/disable coffee drops.");
        INTERVAL_MIN = c.getInt("DropIntervalMin", cat, INTERVAL_MIN, 0, Integer.MAX_VALUE, "The minimum time between coffee drops. Must be less than maximum and greater than zero.");
        INTERVAL_MAX = c.getInt("DropIntervalMax", cat, INTERVAL_MAX, 0, Integer.MAX_VALUE, "The maximum time between coffee drops. Must be greater than minimum and greater than zero.");
        if (INTERVAL_MIN >= INTERVAL_MAX || INTERVAL_MIN == 0 || INTERVAL_MAX == 0) {
            MODULE_ENABLED = false;
        }
    }

    public static void tickRabbit(EntityRabbit rabbit) {
        if (!MODULE_ENABLED || rabbit.field_70170_p.field_72995_K) {
            return;
        }
        Random rand = SilentGems.random;
        if (!rabbit.getEntityData().func_74764_b(NBT_TIME_TO_NEXT_COFFEE)) {
            rabbit.getEntityData().func_74768_a(NBT_TIME_TO_NEXT_COFFEE, ModuleCoffee.getIntervalToNextCoffee(rabbit, rand));
        }
        int time = rabbit.getEntityData().func_74762_e(NBT_TIME_TO_NEXT_COFFEE);
        if (--time <= 0) {
            int rabbitType = rabbit.func_175531_cl();
            ItemStack coffee = ModuleCoffee.getCoffeeForRabbitType(rabbitType);
            if (StackHelper.isValid((ItemStack)coffee)) {
                rabbit.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                rabbit.func_70099_a(StackHelper.safeCopy((ItemStack)coffee), 0.0f);
            }
            time = ModuleCoffee.getIntervalToNextCoffee(rabbit, rand);
        }
        rabbit.getEntityData().func_74768_a(NBT_TIME_TO_NEXT_COFFEE, time);
    }

    private static ItemStack getCoffeeForRabbitType(int rabbitType) {
        return ModItems.food.coffeeCup;
    }

    private static final int getIntervalToNextCoffee(EntityRabbit rabbit, Random rand) {
        return INTERVAL_MIN + rand.nextInt(INTERVAL_MAX - INTERVAL_MIN);
    }
}

