/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.client;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.lib.client.IModelData;
import net.silentchaos512.gems.util.ToolHelper;

@SideOnly(value=Side.CLIENT)
public class ToolModelData
implements IModelData {
    ModelResourceLocation[][] models;
    int[] colors;

    public ToolModelData(ItemStack tool) {
        int totalFrames = ToolRenderHelper.getInstance().getTotalAnimationFrames(tool);
        this.models = new ModelResourceLocation[totalFrames][ToolPartPosition.values().length];
        this.colors = new int[ToolPartPosition.values().length];
        for (ToolPartPosition pass : ToolPartPosition.values()) {
            ToolPart part = ToolHelper.getRenderPart(tool, pass);
            if (part != null) {
                for (int frame = 0; frame < totalFrames; ++frame) {
                    this.models[frame][pass.ordinal()] = part.getModel(tool, pass, frame);
                }
                this.colors[pass.ordinal()] = part.getColor(tool, pass, 0);
                continue;
            }
            this.colors[pass.ordinal()] = 0xFFFFFF;
        }
    }

    @Override
    public ModelResourceLocation getModel(IPartPosition pos, int frame) {
        int pass = pos.getRenderPass();
        if (frame < 0 || frame >= this.models.length || pass < 0 || pass >= this.models[0].length) {
            return null;
        }
        return this.models[frame][pass];
    }

    @Override
    public int getColor(IPartPosition pos, int frame) {
        int pass = pos.getRenderPass();
        if (pass < 0 || pass >= this.colors.length) {
            return 0xFFFFFF;
        }
        return this.colors[pos.getRenderPass()];
    }
}

