/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.tool.ItemGemAxe;
import net.silentchaos512.gems.item.tool.ItemGemPickaxe;
import net.silentchaos512.gems.item.tool.ItemGemShovel;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemPaxel
extends ItemGemPickaxe {
    public static final Material[] EFFECTIVE_MATERIALS = ItemGemPaxel.constructMaterialArray();

    public ItemGemPaxel() {
        this.func_77655_b("silentgems:Paxel");
        this.materialLength = 6;
    }

    private static Material[] constructMaterialArray() {
        Set set = Sets.newConcurrentHashSet();
        set.addAll(ItemGemPickaxe.BASE_EFFECTIVE_MATERIALS);
        set.addAll(ItemGemShovel.BASE_EFFECTIVE_MATERIALS);
        set.addAll(ItemGemAxe.BASE_EFFECTIVE_MATERIALS);
        for (Material mat : ItemGemPickaxe.EXTRA_EFFECTIVE_MATERIALS) {
            set.add(mat);
        }
        for (Material mat : ItemGemAxe.EXTRA_EFFECTIVE_MATERIALS) {
            set.add(mat);
        }
        return set.toArray(new Material[set.size()]);
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.paxel;
    }

    @Override
    public ItemStack constructTool(boolean supercharged, ItemStack material) {
        return this.constructTool(supercharged, material, material, material, material, material);
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return StackHelper.empty();
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamageModifier() {
        return 2.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -3.2f;
    }

    @Override
    public float getHarvestSpeedMultiplier() {
        return 0.75f;
    }

    @Override
    public float getDurabilityMultiplier() {
        return 1.25f;
    }

    @Override
    public float getRepairMultiplier() {
        return 0.7f;
    }

    @Override
    public boolean isSuperTool() {
        return true;
    }

    @Override
    public Material[] getExtraEffectiveMaterials(ItemStack tool) {
        return ToolHelper.isBroken(tool) ? new Material[]{} : EFFECTIVE_MATERIALS;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        return ToolHelper.getDigSpeed(stack, state, EFFECTIVE_MATERIALS);
    }

    @Override
    protected boolean canHarvestBlock(IBlockState state, int toolLevel) {
        if (state.func_177230_c().getHarvestLevel(state) > toolLevel) {
            return false;
        }
        for (Material mat : EFFECTIVE_MATERIALS) {
            if (!mat.equals(state.func_185904_a())) continue;
            return true;
        }
        return super.canHarvestBlock(state, toolLevel);
    }

    @Override
    public Set<String> getToolClasses(ItemStack stack) {
        return ToolHelper.isBroken(stack) ? ImmutableSet.of() : ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe");
    }

    @Override
    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, "hhh", "hrh", "hr ");
        }
    }

    @Override
    public String getName() {
        return "Paxel";
    }
}

