/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemAxe
extends ItemAxe
implements IRegistryObject,
ITool {
    public static final Set<Material> BASE_EFFECTIVE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151572_C, Material.field_151575_d});
    public static final Material[] EXTRA_EFFECTIVE_MATERIALS = new Material[]{Material.field_151575_d, Material.field_151584_j, Material.field_151585_k, Material.field_151582_l};

    public ItemGemAxe() {
        super(ToolHelper.FAKE_MATERIAL, 0.0f, 0.0f);
        this.func_77655_b("silentgems:Axe");
        this.setNoRepair();
    }

    public ItemStack constructTool(boolean supercharged, ItemStack material) {
        return this.constructTool(supercharged, material, material, material);
    }

    public ItemStack constructTool(boolean supercharged, ItemStack ... materials) {
        ItemStack rod = supercharged ? ModItems.craftingMaterial.toolRodGold : new ItemStack(Items.field_151055_y);
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.axe;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return StackHelper.empty();
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -3.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMeleeDamageModifier() {
        return 5.0f;
    }

    @Override
    public boolean isDiggingTool() {
        return true;
    }

    @Override
    public Material[] getExtraEffectiveMaterials(ItemStack stack) {
        return EXTRA_EFFECTIVE_MATERIALS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ToolHelper.onItemUse(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean canceled = super.onBlockStartBreak(stack, pos, player);
        if (!canceled) {
            ToolHelper.onBlockStartBreak(stack, pos, player);
        }
        return canceled;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ToolHelper.getItemEnchantability(stack);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return ToolHelper.getDigSpeed(stack, state, EXTRA_EFFECTIVE_MATERIALS);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return ToolHelper.onBlockDestroyed(stack, world, state, pos, entityLiving);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState state) {
        if (super.getHarvestLevel(stack, toolClass, player, state) < 0 || ToolHelper.isBroken(stack)) {
            return -1;
        }
        return ToolHelper.getHarvestLevel(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ToolHelper.getAttributeModifiers(slot, stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        return ToolHelper.hitEntity(stack, entity1, entity2);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return ToolHelper.getIsRepairable(stack1, stack2);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack tool) {
        return this.canHarvestBlock(state, ToolHelper.getHarvestLevel(tool));
    }

    public boolean func_150897_b(IBlockState state) {
        return this.canHarvestBlock(state, 10);
    }

    private boolean canHarvestBlock(IBlockState state, int toolLevel) {
        if (state.func_177230_c().getHarvestLevel(state) > toolLevel) {
            return false;
        }
        if (BASE_EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return true;
        }
        for (Material mat : EXTRA_EFFECTIVE_MATERIALS) {
            if (!mat.equals(state.func_185904_a())) continue;
            return true;
        }
        return super.func_150897_b(state);
    }

    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, "hh", "hr", " r");
        }
    }

    public void addOreDict() {
    }

    public String getName() {
        return "Axe";
    }

    public String getFullName() {
        return this.getModId() + ":" + this.getName();
    }

    public String getModId() {
        return "silentgems";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        models.put(0, ToolRenderHelper.SMART_MODEL);
    }

    public boolean registerModels() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        ToolRenderHelper.getInstance().clAddInformation(stack, player.field_70170_p, list, advanced);
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().clAddInformation(stack, world, list, flag == ITooltipFlag.TooltipFlags.ADVANCED);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        this.clGetSubItems(item, tab, list);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems(item, tab, (List<ItemStack>)list);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems((Item)this, tab, (List<ItemStack>)list);
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems(item, 3));
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }
}

