/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.quiver;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.quiver.IQuiver;
import net.silentchaos512.gems.item.quiver.QuiverHelper;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class ItemQuiver
extends ItemArrow
implements IRegistryObject,
IQuiver {
    public static final int MAX_STACKS = 4;

    public ItemQuiver() {
        this.func_77625_d(1);
        this.func_77655_b(this.getFullName());
        this.setRegistryName(this.getName());
    }

    public EntityArrow func_185052_a(World worldIn, ItemStack quiverStack, EntityLivingBase shooter) {
        IItemHandler itemHandler = this.getInventory(quiverStack);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            boolean playerIsCreativeMode;
            ItemStack arrowStack = itemHandler.getStackInSlot(i);
            if (StackHelper.isEmpty((ItemStack)arrowStack) || !(arrowStack.func_77973_b() instanceof ItemArrow)) continue;
            boolean bl = playerIsCreativeMode = shooter instanceof EntityPlayer && ((EntityPlayer)shooter).field_71075_bZ.field_75098_d;
            if (!playerIsCreativeMode) {
                itemHandler.extractItem(i, 1, false);
                this.updateQuiver(quiverStack, itemHandler, (EntityPlayer)shooter);
            }
            ItemArrow itemArrow = (ItemArrow)arrowStack.func_77973_b();
            EntityArrow entity = itemArrow.func_185052_a(worldIn, arrowStack, shooter);
            if (!playerIsCreativeMode) {
                QuiverHelper.instance.addFiredArrow(entity);
            }
            return entity;
        }
        SilentGems.logHelper.warning((Object)("Quiver could not find arrow! Player: " + shooter.func_70005_c_()));
        return new EntityTippedArrow(worldIn, shooter);
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        int infinity = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow);
        if (infinity <= 0) {
            return true;
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return QuiverHelper.onItemRightClick(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        QuiverHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public void addRecipes(RecipeMaker recipes) {
    }

    public void addOreDict() {
    }

    public String getModId() {
        return "silentgems";
    }

    public String getName() {
        return "QuiverNonEmpty";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        models.put(0, new ModelResourceLocation(this.getFullName(), "inventory"));
    }
}

