/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.tile.TileChaosNode;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.RecipeMaker;

public class ItemNodeMover
extends ItemSL {
    public static final int META_EMPTY = 0;
    public static final int META_FILLED = 1;
    public static final int META_USED = 2;

    public ItemNodeMover() {
        super(1, "silentgems", "NodeMover");
        this.func_77625_d(1);
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack spent = new ItemStack((Item)this, 1, 2);
        ItemStack chaosCore = ModItems.craftingMaterial.chaosCore;
        ItemStack netherShard = ModItems.craftingMaterial.netherShard;
        ItemStack enderFrost = ModItems.craftingMaterial.enderFrost;
        recipes.addSurroundOre("node_mover", empty, (Object)chaosCore, new Object[]{netherShard, enderFrost});
        recipes.addShaped("node_mover_recharge", empty, new Object[]{"sms", Character.valueOf('s'), netherShard, Character.valueOf('m'), spent});
    }

    protected EnumActionResult clOnItemUse(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77952_i() >= 2) {
            return EnumActionResult.PASS;
        }
        if (stack.func_77942_o()) {
            EnumActionResult result = this.releaseNode(stack, worldIn, pos, facing);
            if (result == EnumActionResult.SUCCESS && playerIn instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)playerIn, pos, stack);
            }
            return result;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileChaosNode) {
            return this.captureNode(stack, worldIn, pos, (TileChaosNode)tile);
        }
        return EnumActionResult.PASS;
    }

    protected EnumActionResult releaseNode(ItemStack stack, World worldIn, BlockPos pos, EnumFacing facing) {
        if (!worldIn.func_175623_d(pos = pos.func_177972_a(facing))) {
            return EnumActionResult.PASS;
        }
        worldIn.func_180501_a(pos, ModBlocks.chaosNode.func_176223_P(), 2);
        TileChaosNode tileNode = (TileChaosNode)worldIn.func_175625_s(pos);
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74768_a("x", pos.func_177958_n());
        compound.func_74768_a("y", pos.func_177956_o());
        compound.func_74768_a("z", pos.func_177952_p());
        tileNode.func_145839_a(compound);
        stack.func_77982_d(null);
        stack.func_77964_b(2);
        return EnumActionResult.SUCCESS;
    }

    protected EnumActionResult captureNode(ItemStack stack, World worldIn, BlockPos pos, TileChaosNode tileNode) {
        NBTTagCompound compound = new NBTTagCompound();
        tileNode.func_189515_b(compound);
        stack.func_77982_d(compound);
        stack.func_77964_b(1);
        worldIn.func_175698_g(pos);
        return EnumActionResult.SUCCESS;
    }

    public String getNameForStack(ItemStack stack) {
        return this.itemName + stack.func_77952_i();
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        String name = "silentgems:NodeMover".toLowerCase();
        for (int i = 0; i < 3; ++i) {
            models.put(i, new ModelResourceLocation(name + i, "inventory"));
        }
    }
}

