/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.entity.EntityGemArrow;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemArrow
extends ItemArrow
implements IRegistryObject {
    public static final String NBT_STATS = "SGArrowStats";
    public static final String NBT_DAMAGE = "Damage";
    public static final String NBT_COLOR_HEAD = "ColorHead";
    public static final String NBT_COLOR_SHAFT = "ColorShaft";
    public static final String NBT_COLOR_FLETCHING = "ColorFletching";

    public ItemGemArrow() {
        this.func_77655_b(this.getFullName());
        this.setRegistryName(this.getName());
    }

    public ItemStack construct(ItemStack ... stacks) {
        ItemStack result = new ItemStack((Item)this);
        result.func_77982_d(new NBTTagCompound());
        NBTTagCompound nbtStats = new NBTTagCompound();
        LinkedHashMap<ToolPart, EnumMaterialGrade> partMap = new LinkedHashMap<ToolPart, EnumMaterialGrade>();
        for (ItemStack stack : stacks) {
            ToolPart part = ToolPartRegistry.fromStack(stack);
            EnumMaterialGrade grade = EnumMaterialGrade.fromStack(stack);
            partMap.put(part, grade);
            if (part instanceof ToolPartMain) {
                nbtStats.func_74768_a(NBT_COLOR_HEAD, part.getColor(result, ToolPartPosition.ROD_DECO, 0));
                continue;
            }
            if (!(part instanceof ToolPartRod)) continue;
            nbtStats.func_74768_a(NBT_COLOR_SHAFT, part.getColor(result, ToolPartPosition.ROD_DECO, 0));
        }
        nbtStats.func_74768_a(NBT_COLOR_FLETCHING, 0xFFFFFF);
        ToolStats stats = new ToolStats(result, partMap);
        stats.calculate();
        nbtStats.func_74776_a(NBT_DAMAGE, stats.meleeDamage);
        result.func_77978_p().func_74782_a(NBT_STATS, (NBTBase)nbtStats);
        int count = MathHelper.func_76125_a((int)((int)Math.floor(stats.durability / 48.0f)), (int)4, (int)64);
        StackHelper.setCount((ItemStack)result, (int)count);
        String stackName = ToolHelper.createToolName((Item)this, stacks);
        result.func_151001_c(stackName);
        return result;
    }

    public EntityArrow func_185052_a(World worldIn, ItemStack stack, EntityLivingBase shooter) {
        EntityGemArrow entity = new EntityGemArrow(worldIn, shooter, stack);
        entity.func_70239_b(this.getBaseDamage(stack));
        return entity;
    }

    public double getBaseDamage(ItemStack stack) {
        if (StackHelper.isEmpty((ItemStack)stack) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_STATS)) {
            return 2.0;
        }
        float damage = stack.func_77978_p().func_74775_l(NBT_STATS).func_74760_g(NBT_DAMAGE);
        return 2.0 + ((double)damage - 1.5) / 2.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(String.format("Damage: %.1f", this.getBaseDamage(stack)));
    }

    public void addRecipes(RecipeMaker recipes) {
    }

    public void addOreDict() {
    }

    public String getModId() {
        return "silentgems";
    }

    public String getName() {
        return "Arrow";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        models.put(0, new ModelResourceLocation(this.getFullName(), "inventory"));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack rodWood = new ItemStack(Items.field_151055_y);
        ItemStack rodGold = ModItems.craftingMaterial.toolRodGold;
        for (ToolPartMain part : ToolPartRegistry.getMains()) {
            ItemStack rod;
            ItemStack main = part.getCraftingStack();
            if (!StackHelper.isValid((ItemStack)main) || part.isBlacklisted(main)) continue;
            ItemStack itemStack = rod = part.getTier() == EnumMaterialTier.SUPER ? rodGold : rodWood;
            ItemStack arrow = this.construct(main, rod);
            if (!StackHelper.isValid((ItemStack)arrow)) continue;
            StackHelper.setCount((ItemStack)arrow, (int)1);
            list.add((Object)arrow);
        }
    }
}

