/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.handler;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.network.NetworkHandler;
import net.silentchaos512.gems.network.message.MessageDataSync;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.tile.SyncVariable;

public class PlayerDataHandler {
    public static final String NBT_ROOT = "SilentGemsData";
    private static Map<Integer, PlayerData> playerData = new HashMap<Integer, PlayerData>();

    public static PlayerData get(EntityPlayer player) {
        PlayerData data;
        int key = PlayerDataHandler.getKey(player);
        if (!playerData.containsKey(key)) {
            playerData.put(key, new PlayerData(player));
        }
        if ((data = playerData.get(key)) != null && data.playerWR != null && data.playerWR.get() != player) {
            NBTTagCompound tags = new NBTTagCompound();
            data.writeToNBT(tags);
            playerData.remove(key);
            data = PlayerDataHandler.get(player);
            data.readFromNBT(tags);
        }
        return data;
    }

    public static void cleanup() {
        ArrayList<Integer> remove = new ArrayList<Integer>();
        for (Map.Entry<Integer, PlayerData> item : playerData.entrySet()) {
            PlayerData d = item.getValue();
            if (d == null || d.playerWR.get() != null) continue;
            remove.add(item.getKey());
        }
        Iterator iterator = remove.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            playerData.remove(i);
        }
    }

    private static int getKey(EntityPlayer player) {
        return player.hashCode() << 1 + (player.field_70170_p.field_72995_K ? 1 : 0);
    }

    public static NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        NBTTagCompound persistentData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(NBT_ROOT)) {
            persistentData.func_74782_a(NBT_ROOT, (NBTBase)new NBTTagCompound());
        }
        return persistentData.func_74775_l(NBT_ROOT);
    }

    public static class PlayerData {
        public static final int CHAOS_MAX_TRANSFER = 1000;
        public static final int RECHARGE_COOLDOWN_TIME = 100;
        public static final int HALO_TIME_DEFAULT = 12000;
        @SyncVariable(name="Chaos")
        public int chaos;
        @SyncVariable(name="MaxChaos")
        public int maxChaos;
        @SyncVariable(name="RechargeCooldown")
        public int rechargeCooldown;
        @SyncVariable(name="FlightTime", onRead=false)
        public int flightTime = 200;
        @SyncVariable(name="HaloTime")
        public int haloTime;
        public int magicCooldown;
        public WeakReference<EntityPlayer> playerWR;
        private final boolean client;

        public PlayerData(EntityPlayer player) {
            this.playerWR = new WeakReference<EntityPlayer>(player);
            this.client = player.field_70170_p.field_72995_K;
            this.load();
        }

        public void tick() {
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (this.maxChaos == 0) {
                this.maxChaos = 10000;
            }
            boolean shouldSave = false;
            if (this.magicCooldown > 0) {
                --this.magicCooldown;
                shouldSave = true;
            }
            if (this.rechargeCooldown > 0) {
                --this.rechargeCooldown;
                shouldSave = true;
            }
            if (this.flightTime > 0) {
                --this.flightTime;
                if (this.flightTime == 0 && !player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
                shouldSave = true;
            }
            if (this.haloTime > 0) {
                --this.haloTime;
                shouldSave = true;
            }
            if (shouldSave) {
                this.save();
            }
        }

        public void drainChaos(int amount) {
            if (amount == 0) {
                return;
            }
            this.chaos = Math.max(this.chaos - amount, 0);
            this.rechargeCooldown = 100;
            this.save();
            this.sendUpdateMessage();
        }

        public int sendChaos(int amount) {
            return this.sendChaos(amount, false);
        }

        public int sendChaos(int amount, boolean ignoreCooldown) {
            if (this.rechargeCooldown > 0 && !ignoreCooldown) {
                return 0;
            }
            int pulled = Math.min(this.maxChaos - this.chaos, amount);
            this.chaos += pulled;
            if (pulled > 0) {
                this.save();
                this.sendUpdateMessage();
            }
            return pulled;
        }

        private void sendUpdateMessage() {
            if (!this.client) {
                EntityPlayer player = (EntityPlayer)this.playerWR.get();
                MessageDataSync message = new MessageDataSync(PlayerDataHandler.get(player));
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
            }
        }

        public int getCurrentChaos() {
            return this.chaos;
        }

        public int getMaxChaos() {
            return this.maxChaos;
        }

        public int getChaosChargeSpeed() {
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
            float multi = 0.0f;
            if (mainHand != null && mainHand.func_77973_b() instanceof ITool) {
                multi += ToolHelper.getChargeSpeed(mainHand);
            }
            if (offHand != null && offHand.func_77973_b() instanceof ITool) {
                multi += ToolHelper.getChargeSpeed(offHand);
            }
            if (multi == 0.0f) {
                multi = 1.0f;
            }
            return (int)(multi * 1000.0f);
        }

        public void save() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(tags);
            }
        }

        public void writeToNBT(NBTTagCompound tags) {
            SyncVariable.Helper.writeSyncVars((Object)this, (NBTTagCompound)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
        }

        public void load() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(tags);
            }
        }

        public void readFromNBT(NBTTagCompound tags) {
            SyncVariable.Helper.readSyncVars((Object)this, (NBTTagCompound)tags);
        }
    }

    public static class EventHandler {
        final int SOUL_TICK_DELAY = 600;
        final int SOUL_TICK_SALT = 10 + SilentGems.random.nextInt(60);

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                PlayerDataHandler.cleanup();
            }
        }

        @SubscribeEvent
        public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                PlayerDataHandler.get(player).tick();
                if ((player.field_70170_p.func_82737_E() + (long)this.SOUL_TICK_SALT) % 600L == 0L) {
                    SoulManager.queueSoulsForWrite(player);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                MessageDataSync message = new MessageDataSync(PlayerDataHandler.get(event.player));
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)event.player);
            }
        }

        @SubscribeEvent
        public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            SoulManager.writeToolSoulsToNBT(event.player);
        }
    }
}

