/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.event;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IAmmoTool;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.ArmorPartFrame;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.client.gui.GuiCrosshairs;
import net.silentchaos512.gems.client.gui.GuiToolSouls;
import net.silentchaos512.gems.client.handler.ClientTickHandler;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.client.render.particle.ParticleRenderDispatcher;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemChaosGem;
import net.silentchaos512.gems.lib.TooltipHelper;
import net.silentchaos512.gems.skills.SkillAreaMiner;
import net.silentchaos512.gems.skills.SkillAreaTill;
import net.silentchaos512.gems.skills.SkillLumberjack;
import net.silentchaos512.gems.skills.ToolSkill;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.client.render.BufferBuilderSL;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.StackHelper;

public class GemsClientEvents {
    public static String debugTextOverlay = "";
    LocalizationHelper loc = SilentGems.localizationHelper;
    int fovModifier = 0;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (SilentGems.instance.isDevBuild() && GemsConfig.DEBUG_MODE && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            GlStateManager.func_179094_E();
            float scale = 1.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            int y = 5;
            for (String line : debugTextOverlay.split("\\n")) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(line, 5.0f, (float)y, 0xFFFFFF);
                y += 10;
            }
            GlStateManager.func_179121_F();
        }
        ModItems.teleporterLinker.renderGameOverlay(event);
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            ItemChaosGem.Gui.renderGameOverlay(Minecraft.func_71410_x());
        }
        this.renderCrosshairs(event);
        this.renderArmorExtra(event);
        this.renderAmmoCount(event);
        GuiToolSouls.renderAPBars(event);
        GuiToolSouls.renderXPBar(event);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ParticleRenderDispatcher.dispatch();
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ToolPart part;
        boolean ctrlDown = KeyTracker.isControlDown();
        boolean shiftDown = KeyTracker.isShiftDown();
        ItemStack stack = event.getItemStack();
        ToolPart toolPart = part = StackHelper.isValid((ItemStack)stack) ? ToolPartRegistry.fromStack(stack) : null;
        if (part != null && !part.isBlacklisted(stack)) {
            if (part instanceof ToolPartRod) {
                this.onTooltipForToolRod(event, stack, part, ctrlDown, shiftDown);
            } else if (part instanceof ToolPartMain) {
                this.onTooltipForToolMaterial(event, stack, part, ctrlDown, shiftDown);
            } else if (part instanceof ArmorPartFrame) {
                event.getToolTip().add(TextFormatting.GOLD + "Armor Frame");
            }
        }
    }

    private void onTooltipForToolRod(ItemTooltipEvent event, ItemStack stack, ToolPart part, boolean ctrlDown, boolean shiftDown) {
        int index = 1;
        String sep = this.loc.getMiscText("Tooltip.Separator", new Object[0]);
        List list = event.getToolTip();
        ToolPartRod.Stats stats = ((ToolPartRod)part).getStats();
        list.add(index++, this.loc.getMiscText("ToolPart.Rod", new Object[0]));
        if (ctrlDown) {
            String line = "";
            for (EnumMaterialTier tier : part.getCompatibleTiers()) {
                if (!line.isEmpty()) {
                    line = line + ", ";
                }
                line = line + tier.getLocalizedName();
            }
            list.add(index++, this.loc.getMiscText("ToolPart.ValidTiers", new Object[0]));
            list.add(index++, "  " + line);
            list.add(index++, sep);
            TextFormatting color = TextFormatting.GOLD;
            list.add(index++, color + TooltipHelper.getAsColoredPercentage("HarvestSpeed", stats.harvestSpeedMulti));
            color = TextFormatting.DARK_GREEN;
            list.add(index++, color + TooltipHelper.getAsColoredPercentage("MeleeDamage", stats.meleeDamageMulti));
            list.add(index++, color + TooltipHelper.getAsColoredPercentage("MagicDamage", stats.magicDamageMulti));
            color = TextFormatting.BLUE;
            list.add(index++, color + TooltipHelper.getAsColoredPercentage("Durability", stats.durabilityMulti));
            list.add(index++, color + TooltipHelper.getAsColoredPercentage("Enchantability", stats.enchantabilityMulti));
            list.add(index++, sep);
            if (shiftDown) {
                list.add(index++, TextFormatting.DARK_GRAY + "* Part key: " + part.getKey());
            }
        } else {
            list.add(index++, this.loc.getMiscText("PressCtrl", new Object[0]));
        }
    }

    private void onTooltipForToolMaterial(ItemTooltipEvent event, ItemStack stack, ToolPart part, boolean ctrlDown, boolean shiftDown) {
        int index = 1;
        String sep = this.loc.getMiscText("Tooltip.Separator", new Object[0]);
        List list = event.getToolTip();
        EnumMaterialGrade grade = EnumMaterialGrade.fromStack(stack);
        if (grade != EnumMaterialGrade.NONE) {
            list.add(index++, this.loc.getMiscText("ToolPart.Grade", new Object[]{grade.getLocalizedName()}));
        }
        EnumMaterialTier tier = part.getTier();
        String tierName = ToolPart.getColorForRarity(part.getRarity()) + tier.getLocalizedName();
        list.add(index++, this.loc.getMiscText("ToolPart.Tier", new Object[]{tierName}));
        if (ctrlDown) {
            int multi = 100 + EnumMaterialGrade.fromStack((ItemStack)stack).bonusPercent;
            list.add(index++, sep);
            TextFormatting color = TextFormatting.GOLD;
            list.add(index++, color + TooltipHelper.get("HarvestSpeed", part.getHarvestSpeed() * (float)multi / 100.0f));
            list.add(index++, color + TooltipHelper.get("HarvestLevel", part.getHarvestLevel() * multi / 100));
            list.add(index++, sep);
            color = TextFormatting.DARK_GREEN;
            list.add(index++, color + TooltipHelper.get("MeleeSpeed", (int)(part.getMeleeSpeed() * (float)multi)));
            list.add(index++, color + TooltipHelper.get("MeleeDamage", part.getMeleeDamage() * (float)multi / 100.0f));
            list.add(index++, color + TooltipHelper.get("MagicDamage", part.getMagicDamage() * (float)multi / 100.0f));
            list.add(index++, color + TooltipHelper.get("Protection", part.getProtection() * (float)multi / 100.0f));
            list.add(index++, sep);
            color = TextFormatting.BLUE;
            list.add(index++, color + TooltipHelper.get("Durability", part.getDurability() * multi / 100));
            list.add(index++, color + TooltipHelper.get("ChargeSpeed", part.getChargeSpeed() * (float)multi / 100.0f));
            list.add(index++, color + TooltipHelper.get("Enchantability", part.getEnchantability() * multi / 100));
            list.add(index++, sep);
            if (shiftDown) {
                event.getToolTip().add(index++, TextFormatting.DARK_GRAY + "* Part key: " + part.getKey());
            }
        } else {
            list.add(index++, TextFormatting.GOLD + this.loc.getMiscText("PressCtrl", new Object[0]));
        }
    }

    private void renderCrosshairs(RenderGameOverlayEvent event) {
        ToolSkill skill;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
        if (mainHand == null) {
            return;
        }
        Item item = mainHand.func_77973_b();
        if (event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && ToolHelper.isSpecialAbilityEnabled(mainHand) && (skill = ToolHelper.getSuperSkill(mainHand)) != null) {
            event.setCanceled(true);
            int type = skill == SkillAreaMiner.INSTANCE || skill == SkillAreaTill.INSTANCE ? 0 : (skill == SkillLumberjack.INSTANCE ? 1 : 2);
            GuiCrosshairs.INSTANCE.renderOverlay(event, type, skill);
        }
    }

    private void renderArmorExtra(RenderGameOverlayEvent event) {
        if (!GemsConfig.SHOW_BONUS_ARMOR_BAR || !event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)0.3f);
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        int level = ForgeHooks.getTotalArmorValue((EntityPlayer)Minecraft.func_71410_x().field_71439_g) - 20;
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                GemsClientEvents.drawTexturedModalRect(left, top, 34, 9, 9, 9);
            } else if (i == level) {
                GemsClientEvents.drawTexturedModalRect(left, top, 25, 9, 5, 9);
            }
            left += 8;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderAmmoCount(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack right = player.func_184614_ca();
        ItemStack left = player.func_184592_cb();
        this.doAmmoCountWithOffset(left, width, height, -7, 3);
        this.doAmmoCountWithOffset(right, width, height, 5, 3);
    }

    private void doAmmoCountWithOffset(ItemStack tool, int width, int height, int xOffset, int yOffset) {
        if (tool != null && tool.func_77973_b() instanceof IAmmoTool) {
            FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
            IAmmoTool ammo = (IAmmoTool)tool.func_77973_b();
            int amount = ammo.getAmmo(tool);
            String str = "" + amount;
            int stringWidth = fontRender.func_78256_a(str);
            float scale = 0.7f;
            int posX = (int)((float)(width / 2 + xOffset) / scale);
            int posY = (int)((float)(height / 2 + yOffset) / scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            fontRender.func_78276_b(str, posX, posY, amount > 0 ? 0xFFFFFF : 0xFF0000);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilderSL vertexbuffer = BufferBuilderSL.INSTANCE.acquireBuffer(tessellator);
        vertexbuffer.begin(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.pos((double)(x + 0), (double)(y + height), 0.0).tex((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).endVertex();
        vertexbuffer.pos((double)(x + width), (double)(y + height), 0.0).tex((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).endVertex();
        vertexbuffer.pos((double)(x + width), (double)(y + 0), 0.0).tex((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).endVertex();
        vertexbuffer.pos((double)(x + 0), (double)(y + 0), 0.0).tex((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).endVertex();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onFOVModifier(EntityViewRenderEvent.FOVModifier event) {
        event.setFOV(event.getFOV() - ClientTickHandler.fovModifier);
    }

    @SubscribeEvent
    public void stitchTexture(TextureStitchEvent.Pre pre) {
        SilentGems.logHelper.info((Object)"Stitching misc textures into the map - M4thG33k");
        pre.getMap().func_174942_a(new ResourceLocation("silentgems", "blocks/ChaosPylonPassive"));
        pre.getMap().func_174942_a(new ResourceLocation("silentgems", "blocks/ChaosPylonBurner"));
        pre.getMap().func_174942_a(new ResourceLocation("silentgems", "blocks/ChaosAltar"));
    }
}

