/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.config;

import net.silentchaos512.gems.config.GemsConfig;

public class GemsConfigHC {
    public static boolean HARD_SUPER_GEMS;
    static final boolean HARD_SUPER_GEMS_DEFAULT = false;
    public static EnumRepairLogic REPAIR_LOGIC;
    static final EnumRepairLogic REPAIR_LOGIC_DEFAULT;
    public static boolean TOOLS_BREAK;
    static final boolean TOOLS_BREAK_DEFAULT = false;
    public static final String CAT_HC = "main.hardcore";
    public static final String CAT_RECIPE = "main.hardcore.recipes";
    public static final String CAT_TOOLS = "main.hardcore.tools";
    public static final String CAT_VANILLA_TOOLS = "main.hardcore.vanilla_tools";

    public static void load(GemsConfig config) {
        config.getConfiguration().setCategoryComment(CAT_RECIPE, "Hardcore recipes. Require a Minecraft restart for changes to take effect.");
        config.getConfiguration().setCategoryRequiresMcRestart(CAT_RECIPE, true);
        HARD_SUPER_GEMS = config.loadBoolean("Hard Supercharged Gems", CAT_RECIPE, false, "If enabled, supercharged gems will require ender essence instead of glowstone.");
        REPAIR_LOGIC = EnumRepairLogic.loadConfig(config);
        TOOLS_BREAK = config.loadBoolean("Tools Break Permanently", CAT_TOOLS, false, "If enable, tools can break like in vanilla and be lost forever.");
    }

    static {
        REPAIR_LOGIC_DEFAULT = EnumRepairLogic.MATERIAL_BASED;
    }

    public static enum EnumRepairLogic {
        CLASSIC,
        MATERIAL_BASED,
        HARD_MATERIAL_BASED,
        NOT_ALLOWED;


        static EnumRepairLogic loadConfig(GemsConfig config) {
            String[] validValues = new String[EnumRepairLogic.values().length];
            for (int i = 0; i < EnumRepairLogic.values().length; ++i) {
                validValues[i] = EnumRepairLogic.values()[i].name();
            }
            String str = config.getConfiguration().getString("Repair Logic", GemsConfigHC.CAT_TOOLS, REPAIR_LOGIC_DEFAULT.name(), "Determines how tools/armor are repaired via decorating.\n  CLASSIC - Old logic, based solely on the tier of the tool/armor and the material.\n  MATERIAL_BASED - Based on the durability of the repair material.\n  HARD_MATERIAL_BASED - Material based, but with lower repair values.\n  NOT_ALLOWED - Decorating does not repair tools or armor.", validValues);
            for (EnumRepairLogic mode : EnumRepairLogic.values()) {
                if (!mode.name().equalsIgnoreCase(str)) continue;
                return mode;
            }
            return REPAIR_LOGIC_DEFAULT;
        }
    }
}

