/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.render;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.client.render.ToolItemOverrideHandler;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.item.tool.ItemGemBow;
import net.silentchaos512.gems.item.tool.ItemGemScepter;
import net.silentchaos512.gems.lib.module.ModuleAprilTricks;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.client.model.MultiLayerModelSL;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.util.LogHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ToolModel
extends MultiLayerModelSL {
    private static ModelManager modelManager = null;
    private final IBakedModel baseModel;
    private ItemStack tool;
    private boolean isGui = false;
    private static ItemTransformVec3f thirdPersonLeft = null;
    private static ItemTransformVec3f thirdPersonRight = null;
    private static ItemTransformVec3f firstPersonLeft = null;
    private static ItemTransformVec3f firstPersonRight = null;

    public ToolModel(IBakedModel baseModel) {
        super(baseModel);
        this.baseModel = baseModel;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        this.tool = stack;
        return this;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IBakedModel model;
        LogHelper log = SilentGems.logHelper;
        if (this.tool == null) {
            return new ArrayList<BakedQuad>();
        }
        if (modelManager == null) {
            modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        }
        ArrayList quads = Lists.newArrayList();
        IBakedModel rodModel = null;
        Item item = this.tool.func_77973_b();
        if (ToolHelper.getMaxDamage(this.tool) <= 0 && this.tool.func_77973_b() instanceof IRegistryObject) {
            String name = ((IRegistryObject)this.tool.func_77973_b()).getName();
            ModelResourceLocation location = new ModelResourceLocation("silentgems:" + name.toLowerCase() + "/_error", "inventory");
            IBakedModel model2 = modelManager.func_174953_a(location);
            if (model2 != null) {
                quads.addAll(model2.func_188616_a(state, side, rand));
            }
            return quads;
        }
        for (ToolPartPosition partPos : ToolPartPosition.values()) {
            ModelResourceLocation location;
            if (this.tool.func_77973_b() instanceof ItemGemScepter) {
                if (partPos == ToolPartPosition.ROD) {
                    location = ToolRenderHelper.getInstance().getModel(this.tool, partPos);
                    rodModel = modelManager.func_174953_a(location);
                    continue;
                }
                if (partPos == ToolPartPosition.ROD_DECO) {
                    quads.addAll(rodModel.func_188616_a(state, side, rand));
                }
            }
            if ((location = ToolRenderHelper.getInstance().getModel(this.tool, partPos)) == null || (model = modelManager.func_174953_a(location)) == null) continue;
            quads.addAll(model.func_188616_a(state, side, rand));
        }
        if (ModuleAprilTricks.instance.isEnabled() && ModuleAprilTricks.instance.isRightDay()) {
            model = modelManager.func_174953_a(ToolRenderHelper.getInstance().modelGooglyEyes);
            quads.addAll(model.func_188616_a(state, side, rand));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        Vector3f rotation = new Vector3f();
        Vector3f translation = new Vector3f();
        Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        rotation = new Vector3f(0.0f, -1.5707964f, 0.6108653f);
        translation = new Vector3f(0.0f, 5.5f, 2.5f);
        if (this.tool != null && this.tool.func_77973_b() == ModItems.katana) {
            translation.y += 2.0f;
        }
        translation.scale(0.0625f);
        thirdPersonRight = new ItemTransformVec3f(rotation, translation, scale);
        rotation = new Vector3f(0.0f, 1.5707964f, -0.6108653f);
        thirdPersonLeft = new ItemTransformVec3f(rotation, translation, scale);
        rotation = new Vector3f(0.0f, -1.5707964f, 0.43633235f);
        translation = new Vector3f(1.13f, 3.2f, 1.13f);
        if (this.tool != null && this.tool.func_77973_b() == ModItems.katana) {
            translation.y += 1.5f;
        }
        translation.scale(0.0625f);
        scale = new Vector3f(0.68f, 0.68f, 0.68f);
        firstPersonRight = new ItemTransformVec3f(rotation, translation, scale);
        rotation = new Vector3f(0.0f, 1.5707964f, -0.43633235f);
        firstPersonLeft = new ItemTransformVec3f(rotation, translation, scale);
        return new ItemCameraTransforms(thirdPersonLeft, thirdPersonRight, firstPersonLeft, firstPersonRight, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        boolean isBow = this.tool != null && this.tool.func_77973_b() instanceof ItemGemBow;
        Matrix4f matrix = new Matrix4f();
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_188039_n);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_188038_m);
                break;
            }
            case GUI: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_178354_e);
                this.isGui = true;
                break;
            }
            case HEAD: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_178353_d);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_188037_l);
                if (!isBow) break;
                matrix.setTranslation(new javax.vecmath.Vector3f(0.0f, 0.0f, 0.2f));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_188036_k);
                if (!isBow) break;
                matrix.setTranslation(new javax.vecmath.Vector3f(0.0f, 0.0f, 0.2f));
                break;
            }
            case GROUND: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_181699_o);
                matrix.setScale(matrix.getScale() * 0.5f);
                break;
            }
            case FIXED: {
                matrix = ToolModel.getMatrix(this.func_177552_f().field_181700_p);
                matrix.rotY((float)Math.PI);
                break;
            }
        }
        if (this.tool != null && this.tool.func_77973_b() == ModItems.katana) {
            if (cameraTransformType != ItemCameraTransforms.TransformType.GUI) {
                matrix.setScale(matrix.getScale() * 1.3f);
            }
        } else if (this.tool != null && this.tool.func_77973_b() == ModItems.scepter) {
            if (cameraTransformType != ItemCameraTransforms.TransformType.GUI) {
                matrix.setScale(matrix.getScale() * 1.2f);
            }
        } else if (this.tool != null && this.tool.func_77973_b() == ModItems.paxel) {
            if (cameraTransformType != ItemCameraTransforms.TransformType.GUI) {
                if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                    matrix.setScale(matrix.getScale() * 1.1f);
                } else {
                    matrix.setScale(matrix.getScale() * 1.2f);
                }
            }
        } else if (this.tool != null && this.tool.func_77973_b() == ModItems.dagger && cameraTransformType != ItemCameraTransforms.TransformType.GUI) {
            matrix.setScale(matrix.getScale() * 0.85f);
        }
        return Pair.of((Object)((Object)this), (Object)matrix);
    }

    public ItemOverrideList func_188617_f() {
        return ToolItemOverrideHandler.INSTANCE;
    }

    public static Matrix4f getMatrix(ItemTransformVec3f transform) {
        Matrix4f m = new Matrix4f();
        Matrix4f t = new Matrix4f();
        m.setIdentity();
        m.setTranslation(TRSRTransformation.toVecmath((Vector3f)transform.field_178365_c));
        t.setIdentity();
        t.rotY(transform.field_178364_b.y);
        m.mul(t);
        t.setIdentity();
        t.rotX(transform.field_178364_b.x);
        m.mul(t);
        t.setIdentity();
        t.rotZ(transform.field_178364_b.z);
        m.mul(t);
        t.setIdentity();
        t.m00 = transform.field_178363_d.x;
        t.m11 = transform.field_178363_d.y;
        t.m22 = transform.field_178363_d.z;
        m.mul(t);
        return m;
    }
}

