/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.client.handler.ClientTickHandler;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import org.lwjgl.util.Color;

@SideOnly(value=Side.CLIENT)
public class GuiChaosBar
extends Gui {
    public static final GuiChaosBar INSTANCE = new GuiChaosBar(Minecraft.func_71410_x());
    public static final ResourceLocation TEXTURE = new ResourceLocation("silentgems", "textures/gui/hud.png");
    public static final int POPUP_TIME = 300;
    public static final float COLOR_CHANGE_DELAY = 200.0f;
    public static final float COLOR_CHANGE_STEP = 8.0f;
    private int currentChaos = 0;
    private int maxChaos = 10000;
    private int lastUpdateTime = 0;
    private int currentTime;
    private Minecraft mc;

    public GuiChaosBar(Minecraft mc) {
        this.mc = mc;
    }

    public void update(int currentChaos, int maxChaos) {
        this.currentChaos = currentChaos;
        this.maxChaos = maxChaos < currentChaos ? currentChaos : maxChaos;
        this.show();
    }

    public void show() {
        this.lastUpdateTime = ClientTickHandler.ticksInGame;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.AIR) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        this.currentTime = ClientTickHandler.ticksInGame;
        if (player.field_71075_bZ.field_75098_d || !GemsConfig.CHAOS_BAR_SHOW_ALWAYS && this.currentTime > this.lastUpdateTime + 300) {
            return;
        }
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        int chaos = data.getCurrentChaos();
        int maxChaos = data.getMaxChaos();
        int chaosHalves = (int)(20.0f * (float)chaos / (float)maxChaos);
        int rowHeight = 10;
        int left = width / 2 + 10 + GemsConfig.CHAOS_BAR_OFFSET_X;
        int top = height - GuiIngameForge.right_height + GemsConfig.CHAOS_BAR_OFFSET_Y;
        if (GemsConfig.CHAOS_BAR_BUMP_HEIGHT) {
            GuiIngameForge.right_height += rowHeight;
        }
        boolean textureX = false;
        int textureY = 23;
        int textureWidth = 9;
        int textureHeight = 9;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        mc.field_71446_o.func_110577_a(TEXTURE);
        for (int i = 9; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(x, y, 18, 23, 9, 9);
            Color color = new Color();
            float hue = ((float)this.currentTime + 8.0f * (float)i) % 200.0f / 200.0f;
            color.fromHSB(hue, 0.6f, 1.0f);
            GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            if (i * 2 + 1 < chaosHalves) {
                this.func_73729_b(x, y, 0, 23, 9, 9);
                continue;
            }
            if (i * 2 + 1 != chaosHalves) continue;
            this.func_73729_b(x, y, 9, 23, 9, 9);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

