/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.block.BlockGemSubtypes;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.util.ModRecipeHelper;
import net.silentchaos512.lib.registry.RecipeMaker;

public class BlockGemOre
extends BlockGemSubtypes {
    public BlockGemOre(EnumGem.Set set) {
        super(set, BlockGemOre.nameForSet(set, "GemOre"));
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
    }

    public void addRecipes(RecipeMaker recipes) {
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = this.getGem(i);
            ItemStack ore = gem.getOre();
            ItemStack item = gem.getItem();
            recipes.addSmelting(ore, item, 0.5f);
            ModRecipeHelper.addSagMillRecipe(gem.getGemName() + "Ore", ore, item, this.gemSet == EnumGem.Set.LIGHT ? "endstone" : (this.gemSet == EnumGem.Set.DARK ? "netherrack" : "cobblestone"), 3000);
        }
    }

    public void addOreDict() {
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = this.getGem(i);
            OreDictionary.registerOre((String)gem.getOreOreName(), (ItemStack)gem.getOre());
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.gem;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) + this.gemSet.startMeta;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_180651_a(state) & 0xF);
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0) {
            int j = random.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(random) * (j + 1);
        }
        return this.func_149745_a(random);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Item item = this.func_180660_a(world.func_180495_p(pos), RANDOM, fortune);
        if (item != Item.func_150898_a((Block)this)) {
            return 1 + RANDOM.nextInt(5);
        }
        return 0;
    }
}

