/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class BlockFluffyPuffPlant
extends BlockCrops
implements IRegistryObject {
    public BlockFluffyPuffPlant() {
        this.func_149711_c(0.1f);
        this.func_149663_c("FluffyPlant");
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList list = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(this.func_149866_i())});
        int age = this.func_185527_x(state);
        Random rand = SilentGems.random;
        if (age >= 7) {
            int i;
            for (i = 0; i < 1 + fortune; ++i) {
                if (rand.nextInt(15) > age) continue;
                list.add(new ItemStack(this.func_149866_i()));
            }
            for (i = 0; i < 2 + fortune + rand.nextInt(3); ++i) {
                list.add(new ItemStack(this.func_149865_P()));
            }
        }
        return list;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (StackHelper.isValid((ItemStack)heldItem) && heldItem.func_77973_b() == ModItems.sickle) {
            return false;
        }
        ArrayList drops = Lists.newArrayList();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        if (age >= 7) {
            for (int i = 0; i < 3; ++i) {
                if (i != 0 && RANDOM.nextInt(15) > age) continue;
                drops.add(new ItemStack(this.func_149865_P(), 1, this.func_180651_a(state)));
            }
            if (SilentGems.random.nextFloat() < 0.025f) {
                drops.add(ModItems.soulGem.getStack("FluffyPuff"));
            }
            world.func_175656_a(pos, this.func_176223_P());
        }
        for (ItemStack stack : drops) {
            BlockFluffyPuffPlant.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
        return !drops.isEmpty();
    }

    protected Item func_149866_i() {
        return ModItems.fluffyPuffSeeds;
    }

    protected Item func_149865_P() {
        return ModItems.fluffyPuff;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public String func_149739_a() {
        return "tile.FluffyPlant";
    }

    public void addRecipes(RecipeMaker recipes) {
    }

    public void addOreDict() {
    }

    public String getName() {
        return "FluffyPlant";
    }

    public String getFullName() {
        return this.getModId() + ":" + this.getName();
    }

    public String getModId() {
        return "silentgems";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        String name = this.getFullName().toLowerCase();
        for (int i = 0; i < 4; ++i) {
            models.put(i, new ModelResourceLocation(name + i, "inventory"));
        }
    }
}

