/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.api.stats.ItemStatModifier;

public class ItemStat {
    public static List<ItemStat> ALL_STATS = new ArrayList<ItemStat>();
    protected final String unlocalizedName;
    protected final float defaultValue;
    protected final float minimumValue;
    protected final float maximumValue;

    public ItemStat(String unlocalizedName, float defaultValue, float minValue, float maxValue) {
        this.unlocalizedName = unlocalizedName;
        this.defaultValue = defaultValue;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        if (this.minimumValue > this.maximumValue) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (defaultValue < this.minimumValue) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (defaultValue > this.maximumValue) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
        ALL_STATS.add(this);
    }

    public float clampValue(float value) {
        value = MathHelper.func_76131_a((float)value, (float)this.minimumValue, (float)this.maximumValue);
        return value;
    }

    public float compute(float baseValue, Collection<ItemStatModifier> modifiers) {
        float f0 = baseValue;
        for (ItemStatModifier itemStatModifier : modifiers) {
            if (itemStatModifier.getOperation() != ItemStatModifier.Operation.MAX) continue;
            f0 = Math.max(f0, itemStatModifier.getAmount());
        }
        int count = 0;
        for (ItemStatModifier mod : modifiers) {
            if (mod.getOperation() != ItemStatModifier.Operation.AVERAGE) continue;
            f0 += mod.getAmount();
            ++count;
        }
        if (count > 0) {
            f0 /= (float)count;
        }
        for (ItemStatModifier mod : modifiers) {
            if (mod.getOperation() != ItemStatModifier.Operation.ADD) continue;
            f0 += mod.getAmount();
        }
        float f = f0;
        for (ItemStatModifier mod : modifiers) {
            if (mod.getOperation() != ItemStatModifier.Operation.MULTIPLY) continue;
            f *= mod.getAmount();
        }
        return this.clampValue(f);
    }

    public String toString() {
        return String.format("ItemStat{%s, default=%.2f, min=%.2f, max=%.2f}", this.unlocalizedName, Float.valueOf(this.defaultValue), Float.valueOf(this.minimumValue), Float.valueOf(this.maximumValue));
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public float getMinimumValue() {
        return this.minimumValue;
    }

    public float getMaximumValue() {
        return this.maximumValue;
    }
}

