/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.recipe.altar;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.silentchaos512.lib.util.StackHelper;

public class RecipeChaosAltar {
    public static final List<RecipeChaosAltar> ALL_RECIPES = Lists.newArrayList();
    private ItemStack input;
    private ItemStack output;
    private ItemStack catalyst;
    private int chaosCost;

    public RecipeChaosAltar(ItemStack output, ItemStack input, int chaosCost) {
        this(output, input, chaosCost, null);
    }

    public RecipeChaosAltar(ItemStack output, ItemStack input, int chaosCost, ItemStack catalyst) {
        this.output = output;
        this.input = input;
        this.chaosCost = chaosCost;
        this.catalyst = catalyst;
    }

    public static RecipeChaosAltar getMatchingRecipe(ItemStack inputStack, ItemStack catalystStack) {
        if (StackHelper.isEmpty((ItemStack)inputStack)) {
            return null;
        }
        for (RecipeChaosAltar recipe : ALL_RECIPES) {
            if (!recipe.matches(inputStack, catalystStack)) continue;
            return recipe;
        }
        return null;
    }

    public static RecipeChaosAltar getRecipeByOutput(ItemStack outputStack) {
        if (StackHelper.isEmpty((ItemStack)outputStack)) {
            return null;
        }
        for (RecipeChaosAltar recipe : ALL_RECIPES) {
            if (!recipe.output.func_77969_a(outputStack)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack inputStack) {
        if (StackHelper.isEmpty((ItemStack)inputStack)) {
            return false;
        }
        for (RecipeChaosAltar recipe : ALL_RECIPES) {
            if (!recipe.input.func_77969_a(inputStack)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(ItemStack inputStack, ItemStack catalystStack) {
        boolean catalystMatch = StackHelper.isEmpty((ItemStack)catalystStack) && StackHelper.isEmpty((ItemStack)this.catalyst) || StackHelper.isValid((ItemStack)catalystStack) && catalystStack.func_77969_a(this.catalyst);
        return StackHelper.isValid((ItemStack)inputStack) && StackHelper.isValid((ItemStack)this.input) && StackHelper.isValid((ItemStack)this.output) && inputStack.func_77969_a(this.input) && StackHelper.getCount((ItemStack)inputStack) >= StackHelper.getCount((ItemStack)this.input) && catalystMatch;
    }

    public ItemStack getInput() {
        return StackHelper.safeCopy((ItemStack)this.input);
    }

    public ItemStack getOutput() {
        return StackHelper.safeCopy((ItemStack)this.output);
    }

    public ItemStack getCatalyst() {
        return StackHelper.safeCopy((ItemStack)this.catalyst);
    }

    public int getChaosCost() {
        return this.chaosCost;
    }
}

