/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile.module;

import elucent.elulib.ELEvents;
import elucent.elulib.tile.TileCable;
import elucent.elulib.tile.TileModular;
import elucent.elulib.tile.module.FaceConfig;
import elucent.elulib.tile.module.Module;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ModuleEnergy
extends Module {
    public EnergyStorage battery;
    public Map<EnumFacing, EnergyIOProxy> ioProxies = new HashMap<EnumFacing, EnergyIOProxy>();
    public TileModular tile = null;
    public int receiveLimit = 0;
    public int giveLimit = 0;

    public ModuleEnergy(String name, TileModular tile, int capacity, int receiveLimit, int giveLimit) {
        super(name);
        this.receiveLimit = receiveLimit;
        this.giveLimit = giveLimit;
        this.tile = tile;
        this.battery = this.constructBattery(capacity, receiveLimit, giveLimit, 0);
        for (EnumFacing f : EnumFacing.values()) {
            this.ioProxies.put(f, this.constructIOProxy(f, capacity, receiveLimit, giveLimit, 0));
        }
    }

    public int getInputLimit() {
        return this.receiveLimit;
    }

    public int getOutputLimit() {
        return this.giveLimit;
    }

    public EnergyStorage constructBattery(int capacity, int maxIn, int maxOut, int energy) {
        return new EnergyStorage(capacity, maxIn, maxOut, energy);
    }

    public EnergyIOProxy constructIOProxy(EnumFacing face, int capacity, int maxIn, int maxOut, int energy) {
        return new EnergyIOProxy(face, this.tile, this.battery.getMaxEnergyStored(), this.receiveLimit, this.giveLimit, this.battery.getEnergyStored());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing face, TileModular tile) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public Object getCapability(Capability<?> capability, EnumFacing face, TileModular tile) {
        if (face != null) {
            return this.ioProxies.get(face).setTile(tile);
        }
        return this.battery;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("energy", this.battery.getEnergyStored());
        tag.func_74768_a("capacity", this.battery.getMaxEnergyStored());
        tag.func_74768_a("receiveLimit", this.receiveLimit);
        tag.func_74768_a("giveLimit", this.giveLimit);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.battery = this.constructBattery(tag.func_74762_e("capacity"), tag.func_74762_e("receiveLimit"), tag.func_74762_e("giveLimit"), tag.func_74762_e("energy"));
        this.giveLimit = tag.func_74762_e("giveLimit");
        this.receiveLimit = tag.func_74762_e("receiveLimit");
    }

    @Override
    public void onUpdate(TileModular tile) {
        for (EnumFacing f : EnumFacing.values()) {
            IEnergyStorage s;
            TileEntity t;
            if (!this.hasCapability(CapabilityEnergy.ENERGY, f, tile) || tile.config.ioConfig.get(f) != FaceConfig.FaceIO.OUT || tile.func_145831_w().field_72995_K || !tile.validIOModules.contains(this.getModuleName()) || (t = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(f))) == null || !t.hasCapability(CapabilityEnergy.ENERGY, f.func_176734_d()) || (s = (IEnergyStorage)t.getCapability(CapabilityEnergy.ENERGY, f.func_176734_d())) == null) continue;
            int amount = s.receiveEnergy(Math.min(this.giveLimit, this.battery.getEnergyStored()), true);
            if (amount > 0) {
                if (t instanceof TileCable) {
                    ((TileCable)t).from = tile.func_174877_v();
                }
                s.receiveEnergy(amount, false);
                this.battery.extractEnergy(amount, false);
                tile.func_70296_d();
                t.func_70296_d();
                ELEvents.markForUpdate(tile.func_174877_v().func_177972_a(f), t);
                continue;
            }
            if (!(t instanceof TileCable)) continue;
            s.receiveEnergy(0, false);
            t.func_70296_d();
            ELEvents.markForUpdate(tile.func_174877_v().func_177972_a(f), t);
        }
    }

    @Override
    public Capability getCapabilityType() {
        return CapabilityEnergy.ENERGY;
    }

    public class EnergyIOProxy
    extends EnergyStorage {
        EnumFacing face;
        TileModular tile;

        public EnergyIOProxy(EnumFacing face, TileModular tile, int capacity, int maxReceive, int maxExtract, int energy) {
            super(capacity, maxReceive, maxExtract, energy);
            this.face = EnumFacing.NORTH;
            this.tile = null;
            this.face = face;
            this.tile = tile;
        }

        public EnergyIOProxy setTile(TileModular tile) {
            this.tile = tile;
            return this;
        }

        public int getMaxEnergyStored() {
            return ModuleEnergy.this.battery.getMaxEnergyStored();
        }

        public int getEnergyStored() {
            return ModuleEnergy.this.battery.getEnergyStored();
        }

        public int receiveEnergy(int amount, boolean simulate) {
            if (this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.IN || this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT) {
                this.tile.func_70296_d();
                return ModuleEnergy.this.battery.receiveEnergy(amount, simulate);
            }
            return 0;
        }

        public int extractEnergy(int amount, boolean simulate) {
            if (this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.OUT || this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.NEUTRAL || this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT) {
                this.tile.func_70296_d();
                return ModuleEnergy.this.battery.extractEnergy(amount, simulate);
            }
            return 0;
        }

        public boolean canReceive() {
            return super.canReceive() && (this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.IN || this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT);
        }

        public boolean canExtract() {
            return super.canExtract() && (this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.OUT || this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT);
        }
    }
}

