/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile;

import akka.japi.Pair;
import elucent.elulib.tile.CableManager;
import elucent.elulib.tile.CableWorldData;
import elucent.elulib.tile.TileCable;
import elucent.elulib.tile.module.FaceConfig;
import elucent.elulib.util.Util;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CableNetwork {
    public int ID = 0;
    public Set<BlockPos> cables = new HashSet<BlockPos>();
    private Set<BlockPos> removals = new HashSet<BlockPos>();
    public boolean valid = true;
    public String type = null;
    public boolean dirty = true;
    public CableWorldData data = null;
    public Set<Pair<TileEntity, EnumFacing>> connections = new HashSet<Pair<TileEntity, EnumFacing>>();

    public CableNetwork(CableWorldData data) {
        this.ID = CableManager.getNextID(data);
        this.data = data;
        CableWorldData.networks.put(this.ID, this);
        data.func_76185_a();
    }

    public CableNetwork(CableWorldData data, int id) {
        this.ID = id;
        this.data = data;
        CableWorldData.networks.put(this.ID, this);
        data.func_76185_a();
    }

    public void highlight(World world) {
        IBlockState s;
        for (BlockPos blockPos : this.cables) {
            s = Blocks.field_150399_cn.func_176203_a(Util.rand.nextInt(16));
            world.func_175656_a(blockPos.func_177984_a(), s);
            world.func_184138_a(blockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), s, 8);
        }
        for (Pair pair : this.connections) {
            s = Blocks.field_150399_cn.func_176203_a(Util.rand.nextInt(16));
            world.func_175656_a(((TileEntity)pair.first()).func_174877_v().func_177984_a(), s);
            world.func_184138_a(((TileEntity)pair.first()).func_174877_v().func_177984_a(), Blocks.field_150350_a.func_176223_P(), s, 8);
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    public void tryAddPos(BlockPos pos) {
        if (!this.cables.contains(pos)) {
            this.cables.add(pos);
            this.dirty = true;
            this.data.func_76185_a();
        }
    }

    public void tickRemovals() {
        for (BlockPos p : this.removals) {
            this.cables.remove(p);
        }
        this.removals.clear();
    }

    public boolean needsDistributionTick() {
        return false;
    }

    public void updateConnections(World world) {
        this.dirty = false;
        this.connections.clear();
        for (BlockPos p : this.cables) {
            TileEntity t = world.func_175625_s(p);
            if (!(t instanceof TileCable)) continue;
            TileCable c = (TileCable)t;
            this.processUpdateFor(c);
        }
    }

    public void distribute() {
    }

    public void processUpdateFor(TileCable c) {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t2;
            if (c.config.ioConfig.get(f) == FaceConfig.FaceIO.NEUTRAL || (t2 = c.func_145831_w().func_175625_s(c.func_174877_v().func_177972_a(f))) instanceof TileCable || t2 == null || t2.func_145831_w().func_175623_d(t2.func_174877_v()) || this.cables.contains(t2.func_174877_v())) continue;
            this.connections.add((Pair<TileEntity, EnumFacing>)new Pair((Object)t2, (Object)f.func_176734_d()));
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("positions", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.cables.add(NBTUtil.func_186861_c((NBTTagCompound)list.func_150305_b(i)));
        }
        this.type = tag.func_74779_i("type");
        this.data.func_76185_a();
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList positions = new NBTTagList();
        for (BlockPos p : this.cables) {
            positions.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)p));
        }
        tag.func_74782_a("positions", (NBTBase)positions);
        tag.func_74778_a("type", this.type);
        return tag;
    }
}

