/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.asm;

import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.compareTo("net.minecraft.client.renderer.RenderItem") == 0) {
            return this.patchRenderItemASM(name, basicClass, name.compareTo(transformedName) != 0);
        }
        if (transformedName.compareTo("net.minecraftforge.client.ForgeHooksClient") == 0) {
            return this.patchForgeHooksASM(name, basicClass, name.compareTo(transformedName) != 0);
        }
        return basicClass;
    }

    public byte[] patchForgeHooksASM(String name, byte[] bytes, boolean obfuscated) {
        String targetMethod = "";
        String transformTypeName = "";
        if (obfuscated) {
            targetMethod = "handleCameraTransforms";
            transformTypeName = "Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;";
        } else {
            targetMethod = "handleCameraTransforms";
            transformTypeName = "Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            if (m.name.compareTo(targetMethod) != 0) continue;
            InsnList code = m.instructions;
            List vars = m.localVariables;
            int paramloc = -1;
            if (!obfuscated) {
                paramloc = 1;
            }
            for (int i = 0; i < vars.size() && paramloc == -1; ++i) {
                LocalVariableNode p = (LocalVariableNode)vars.get(i);
                if (p.desc.compareTo(transformTypeName) != 0) continue;
                paramloc = i;
            }
            if (paramloc <= -1) continue;
            MethodInsnNode method = new MethodInsnNode(184, "elucent/elulib/util/RenderUtil", "setTransform", "(" + transformTypeName + ")V", false);
            code.insertBefore(code.get(2), (AbstractInsnNode)method);
            code.insertBefore(code.get(2), (AbstractInsnNode)new VarInsnNode(25, paramloc));
            System.out.println("Successfully patched ForgeHooksClient!");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patchRenderItemASM(String name, byte[] bytes, boolean obfuscated) {
        String targetMethod = "";
        String targetDesc = "";
        if (obfuscated) {
            targetMethod = "func_180454_a";
            targetDesc = "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V";
        } else {
            targetMethod = "renderItem";
            targetDesc = "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            if (m.name.compareTo(targetMethod) != 0 || m.desc.compareTo(targetDesc) != 0) continue;
            InsnList code = m.instructions;
            List vars = m.localVariables;
            int paramloc = 1;
            AbstractInsnNode returnNode = null;
            for (AbstractInsnNode insn : code) {
                if (insn.getOpcode() != 177) continue;
                returnNode = insn;
                break;
            }
            if (returnNode == null || paramloc <= -1) continue;
            MethodInsnNode method = new MethodInsnNode(184, "elucent/elulib/util/RenderUtil", "renderItem", "(Lnet/minecraft/item/ItemStack;)V", false);
            code.insertBefore(returnNode, (AbstractInsnNode)new VarInsnNode(25, paramloc));
            code.insertBefore(returnNode, (AbstractInsnNode)method);
            System.out.println("Successfully loaded RenderItem ASM!");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

