/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class ClientTicker {
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float delta = 0.0f;
    public static float total = 0.0f;
    private static Queue<Runnable> pendingActions = new ArrayDeque<Runnable>();

    public static void addAction(Runnable action) {
        pendingActions.add(action);
    }

    private static void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        } else {
            ClientTicker.calcDelta();
        }
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !gui.func_73868_f()) {
                ++ticksInGame;
                partialTicks = 0.0f;
            }
            while (!pendingActions.isEmpty()) {
                pendingActions.poll().run();
            }
            ClientTicker.calcDelta();
        }
    }
}

