/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.et.base.IETNamespace;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager.NBBPlayerData;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfo;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfoRegistry;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.base.NamespaceLocation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class NBBWorldData
extends WorldSavedData
implements IETNamespace {
    private static final String DATA_NAME = "environmentaltech_nanobotdata";
    protected Map<BeaconInfo, Map<GameProfile, NBBPlayerData>> DATA = new HashMap<BeaconInfo, Map<GameProfile, NBBPlayerData>>();
    int tick = 0;

    public NBBWorldData(String name) {
        super(name);
    }

    public NBBWorldData() {
        super(DATA_NAME);
    }

    public void queueDisable(BeaconInfo bi, GameProfile profile, AttributeCache cache) {
        NBBPlayerData pd;
        Map<GameProfile, NBBPlayerData> pdm = this.DATA.get(bi);
        if (pdm == null) {
            pdm = new HashMap<GameProfile, NBBPlayerData>();
            this.DATA.put(bi, pdm);
        }
        if ((pd = pdm.get(profile)) == null) {
            pd = new NBBPlayerData();
            pdm.put(profile, pd);
        }
        pd.queueDisable(cache);
    }

    public void worldTick(World world) {
        if (this.tick == 20) {
            this.tick = 0;
            for (BeaconInfo bi : this.DATA.keySet()) {
                Map<GameProfile, NBBPlayerData> playerData = this.DATA.get(bi);
                for (GameProfile gp : playerData.keySet()) {
                    NBBPlayerData nbbPD = playerData.get(gp);
                    nbbPD.checkDisable(bi, world);
                }
            }
        }
        ++this.tick;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList data = nbt.func_150295_c("nanobotdata", 10);
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound beaconInfoData = data.func_150305_b(i);
            NamespaceLocation beaconName = NamespaceLocation.fromString((String)beaconInfoData.func_74779_i("beacon_name"));
            BeaconInfo bi = BeaconInfoRegistry.getInstance().getBeaconInfo(beaconName);
            HashMap<GameProfile, NBBPlayerData> beaconPlayerData = new HashMap<GameProfile, NBBPlayerData>();
            NBTTagList playerDataList = beaconInfoData.func_150295_c("player_data", 10);
            for (int j = 0; j < playerDataList.func_74745_c(); ++j) {
                NBTTagCompound tagPD = playerDataList.func_150305_b(j);
                NBBPlayerData nbbPD = new NBBPlayerData();
                nbbPD.readFromNBT(tagPD);
                beaconPlayerData.put(nbbPD.getPlayerID(), nbbPD);
            }
            this.DATA.put(bi, beaconPlayerData);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList data = new NBTTagList();
        for (BeaconInfo bi : this.DATA.keySet()) {
            NBTTagCompound beaconInfoData = new NBTTagCompound();
            beaconInfoData.func_74778_a("beacon_name", bi.getNamespaceLocation().toString());
            NBTTagList nbbPlayerDataList = new NBTTagList();
            for (GameProfile gp : this.DATA.get(bi).keySet()) {
                NBBPlayerData pd = this.DATA.get(bi).get(gp);
                NBTTagCompound playerData = new NBTTagCompound();
                pd.writeToNBT(playerData);
                nbbPlayerDataList.func_74742_a((NBTBase)playerData);
            }
            beaconInfoData.func_74782_a("player_data", (NBTBase)nbbPlayerDataList);
            data.func_74742_a((NBTBase)beaconInfoData);
        }
        compound.func_74782_a("nanobotdata", (NBTBase)data);
        return compound;
    }

    public static NBBWorldData getNBBWorldData(World world) {
        MapStorage ms = world.func_175693_T();
        NBBWorldData data = (NBBWorldData)ms.func_75742_a(NBBWorldData.class, DATA_NAME);
        if (data == null) {
            data = new NBBWorldData(DATA_NAME);
            ms.func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        return data;
    }
}

