/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.attribute;

import com.valkyrieofnight.um.api.attribute.AAttributeCalculator;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeForgeEnergyMultiplier
implements IAttribute<Float> {
    public static AttributeID FORGE_ENERGY_MULTIPLIER = new AttributeID("environmentaltech", "forge_energy_multiplier", ACalcForgeEnergyMultiplier.class);
    protected float multiplier;

    public AttributeForgeEnergyMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public AttributeID getAttributeID() {
        return FORGE_ENERGY_MULTIPLIER;
    }

    public Float getValue() {
        return Float.valueOf(this.multiplier);
    }

    public static final class ACalcForgeEnergyMultiplier
    extends AAttributeCalculator<AttributeForgeEnergyMultiplier, Float, Integer, Integer> {
        public Float calculateFinalValue(List<IAttribute<Float>> attributes) {
            float total = 0.0f;
            for (IAttribute<Float> iAttribute : attributes) {
                total += ((Float)iAttribute.getValue()).floatValue();
            }
            return Float.valueOf(total);
        }

        public Integer calculateModifiedValue(Float attributeFinalValue, Integer unmodifiedValue) {
            return (int)((float)unmodifiedValue.intValue() * this.getMultiplier(attributeFinalValue.floatValue()));
        }

        public float getMultiplier(float totalModificationFactor) {
            return (float)Math.pow(1.12, totalModificationFactor);
        }

        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return Float.valueOf(nbt.func_74760_g(this.getAttribute().toString()));
        }

        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Float data = (Float)obj;
            nbt.func_74776_a(this.getAttribute().toString(), data.floatValue());
            return nbt;
        }
    }
}

