/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.tool.ItemShieldCore;
import cofh.core.util.helpers.DamageHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RAProps;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemShieldFlux
extends ItemShieldCore
implements IEnchantableItem,
IEnergyContainerItem,
IMultiModeItem {
    protected int maxEnergy = 320000;
    protected int maxTransfer = 4000;
    protected int energyPerUse = 200;
    protected int energyPerUseCharged = 800;
    protected int damageCharged = 6;

    public ItemShieldFlux(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 && !this.isEmpowered(stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("empowered"), (stack, world, entity) -> this.isEmpowered(stack) ? 1.0f : 0.0f);
    }

    public ItemShieldFlux setEnergyParams(int maxEnergy, int maxTransfer, int energyPerUse) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.energyPerUse = energyPerUse;
        return this;
    }

    public ItemShieldFlux setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    protected boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) == 1 && this.getEnergyStored(stack) >= this.energyPerUseCharged;
    }

    protected int getEnergyPerUse(ItemStack stack) {
        return this.isEmpowered(stack) ? this.energyPerUseCharged : this.energyPerUse;
    }

    protected int useEnergy(ItemStack stack, boolean simulate) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10);
        if (MathHelper.RANDOM.nextInt(2 + unbreakingLevel) >= 2) {
            return 0;
        }
        return this.extractEnergy(stack, this.isEmpowered(stack) ? this.energyPerUseCharged : this.energyPerUse, simulate);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        RAProps.addEmpoweredTip(this, stack, tooltip);
        if (this.getEnergyStored(stack) >= this.getEnergyPerUse(stack)) {
            tooltip.add("");
            tooltip.add("\u00a7a" + (this.isEmpowered(stack) ? this.damageCharged : 1) + " " + StringHelper.localize((String)"info.cofh.damageFlux") + "\u00a7r");
        }
    }

    public void onHit(ItemStack stack, EntityPlayer player, Entity source) {
        if (source != null && player != source) {
            float potionDamage = 1.0f;
            if (player.func_70644_a(MobEffects.field_76420_g)) {
                potionDamage += (float)player.func_70660_b(MobEffects.field_76420_g).func_76458_c() * 1.3f;
            }
            source.func_70097_a(DamageHelper.causePlayerFluxDamage((EntityPlayer)player), (float)(this.isEmpowered(stack) ? this.damageCharged : 1) * potionDamage);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.showInCreative) {
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0));
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)this.maxEnergy));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y)) {
            return enchantment.equals(Enchantments.field_185307_s);
        }
        return enchantment.field_77351_y.func_77557_a((Item)this);
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
        EntityPlayer thePlayer = (EntityPlayer)player;
        if (thePlayer.field_71075_bZ.field_75098_d || this.getEnergyStored(stack) >= this.getEnergyPerUse(stack)) {
            int fluxDamage = this.isEmpowered(stack) ? this.damageCharged : 1;
            float potionDamage = 1.0f;
            if (player.func_70644_a(MobEffects.field_76420_g)) {
                potionDamage += (float)player.func_70660_b(MobEffects.field_76420_g).func_76458_c() * 1.3f;
            }
            entity.func_70097_a(DamageHelper.causePlayerFluxDamage((EntityPlayer)thePlayer), (float)fluxDamage * potionDamage);
            this.useEnergy(stack, thePlayer.field_71075_bZ.field_75098_d);
        }
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return RAProps.showToolCharge && this.getEnergyStored(stack) > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
            new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.maxTransfer));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
            if (stored == 0) {
                this.setMode(container, 0);
            }
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
    }

    public int getMaxEnergyStored(ItemStack container) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container);
        return this.maxEnergy + this.maxEnergy * enchant / 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

