/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.BlockEmberEmitter;
import teamroots.embers.block.BlockEmberPulser;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.power.IEmberPacketProducer;
import teamroots.embers.power.IEmberPacketReceiver;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityPulser
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer {
    public IEmberCapability capability = new DefaultEmberCapability();
    public BlockPos target = null;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;
    public boolean dirty = false;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEntityPulser() {
        this.capability.setEmberCapacity(2000.0);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityPulser.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityPulser.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityPulser.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityPulser.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityPulser.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityPulser.connectionFromInt(tag.func_74762_e("east"));
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing face;
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150442_at ? (face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN : (world.func_180495_p(pos).func_177230_c() == Blocks.field_150430_aB ? (face = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockButton.field_176387_N)) == Misc.getOppositeVerticalFace(side) : (world.func_180495_p(pos).func_177230_c() == Blocks.field_150429_aA ? (face = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a)) == Misc.getOppositeVerticalFace(side) : world.func_180495_p(pos).func_177230_c() == RegistryManager.caminite_lever && ((face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN)))) {
            return EnumConnection.LEVER;
        }
        return EnumConnection.NONE;
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        IEmberCapability cap;
        ++this.ticksExisted;
        if (this.ticksExisted % 5L == 0L && this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockEmberPulser.facing), -1)) != null && this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockEmberPulser.facing), -1)).hasCapability(EmberCapabilityProvider.emberCapability, null) && (cap = (IEmberCapability)this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockEmberPulser.facing), -1)).getCapability(EmberCapabilityProvider.emberCapability, null)).getEmber() > 0.0 && this.capability.getEmber() < this.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(100.0, true);
            double added = this.capability.addAmount(removed, true);
            this.func_70296_d();
            BlockPos offset = this.func_174877_v().func_177967_a((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockEmberPulser.facing), -1);
            this.func_145831_w().func_175625_s(offset).func_70296_d();
            if (!this.func_145831_w().field_72995_K && !(this.func_145831_w().func_175625_s(offset) instanceof ITileEntityBase)) {
                this.field_145850_b.func_175625_s(offset).func_70296_d();
                EventManager.markTEForUpdate(offset, this.field_145850_b.func_175625_s(offset));
            }
        }
        if ((this.ticksExisted + (long)this.offset) % 20L == 0L && this.func_145831_w().func_175687_A(this.func_174877_v()) != 0 && this.target != null && !this.func_145831_w().field_72995_K && this.capability.getEmber() > 100.0 && this.func_145831_w().func_175625_s(this.target) instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.target)).isFull()) {
            EntityEmberPacket packet = new EntityEmberPacket(this.func_145831_w());
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            double vx = 0.0;
            double vy = 0.0;
            double vz = 0.0;
            if (state.func_177229_b((IProperty)BlockEmberEmitter.facing) == EnumFacing.UP) {
                vy = 0.5;
            }
            if (state.func_177229_b((IProperty)BlockEmberEmitter.facing) == EnumFacing.DOWN) {
                vy = -0.5;
            }
            if (state.func_177229_b((IProperty)BlockEmberEmitter.facing) == EnumFacing.NORTH) {
                vz = -0.5;
                vy = -0.01;
            }
            if (state.func_177229_b((IProperty)BlockEmberEmitter.facing) == EnumFacing.SOUTH) {
                vz = 0.5;
                vy = -0.01;
            }
            if (state.func_177229_b((IProperty)BlockEmberEmitter.facing) == EnumFacing.WEST) {
                vx = -0.5;
                vy = -0.01;
            }
            if (state.func_177229_b((IProperty)BlockEmberEmitter.facing) == EnumFacing.EAST) {
                vx = 0.5;
                vy = -0.01;
            }
            packet.initCustom(this.func_174877_v(), this.target, vx, vy, vz, Math.min(400.0, this.capability.getEmber()));
            this.capability.removeAmount(Math.min(400.0, this.capability.getEmber()), true);
            this.func_145831_w().func_72838_d((Entity)packet);
            this.func_70296_d();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        this.target = pos;
        this.func_70296_d();
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }
}

