/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.block.BlockItemTransfer;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.IPressurizable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityItemPipe;
import teamroots.embers.util.Misc;

public class TileEntityItemTransfer
extends TileEntity
implements ITileEntityBase,
ITickable,
IPressurizable,
IItemPipePriority {
    double angle = 0.0;
    double turnRate = 1.0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityItemTransfer.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!TileEntityItemTransfer.this.filterItem.func_190926_b()) {
                if (!stack.func_190926_b() && TileEntityItemTransfer.this.filterItem.func_77973_b() == stack.func_77973_b() && TileEntityItemTransfer.this.filterItem.func_77952_i() == stack.func_77952_i()) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public ItemStack filterItem = ItemStack.field_190927_a;
    public BlockPos lastReceived = new BlockPos(0, 0, 0);
    public int pressure = 0;
    Random random = new Random();
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (!this.filterItem.func_190926_b()) {
            tag.func_74782_a("filter", (NBTBase)this.filterItem.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74768_a("lastX", this.lastReceived.func_177958_n());
        tag.func_74768_a("lastY", this.lastReceived.func_177956_o());
        tag.func_74768_a("lastZ", this.lastReceived.func_177952_p());
        tag.func_74768_a("pressure", this.pressure);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("filter")) {
            this.filterItem = new ItemStack(tag.func_74775_l("filter"));
        }
        this.lastReceived = new BlockPos(tag.func_74762_e("lastX"), tag.func_74762_e("lastY"), tag.func_74762_e("lastZ"));
        this.pressure = tag.func_74762_e("pressure");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            return facing == state.func_177229_b((IProperty)BlockItemTransfer.facing) || facing == Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)BlockItemTransfer.facing));
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (facing == state.func_177229_b((IProperty)BlockItemTransfer.facing) || facing == Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)BlockItemTransfer.facing))) {
                return (T)this.inventory;
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (heldItem != ItemStack.field_190927_a) {
                this.filterItem = heldItem.func_77946_l();
                this.func_70296_d();
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(true)), 8);
                world.func_184138_a(pos, state, state.func_177226_a((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(true)), 8);
                return true;
            }
            this.filterItem = ItemStack.field_190927_a;
            this.func_70296_d();
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(false)), 8);
            world.func_184138_a(pos, state, state.func_177226_a((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(false)), 8);
            return true;
        }
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        int i;
        this.angle += this.turnRate;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
        ArrayList<Comparable> connections = new ArrayList<Comparable>();
        connections.add(state.func_177229_b((IProperty)BlockItemTransfer.facing));
        if (connections.size() > 0) {
            for (i = 0; i < 1; ++i) {
                ItemStack extracted;
                ItemStack added;
                IItemHandler handler;
                if (this.inventory.getStackInSlot(0).func_190926_b()) continue;
                EnumFacing face = (EnumFacing)connections.get(this.random.nextInt(connections.size()));
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
                if (tile == null || (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                ItemStack passStack = new ItemStack(this.inventory.getStackInSlot(0).func_77973_b(), 1, this.inventory.getStackInSlot(0).func_77960_j());
                if (this.inventory.getStackInSlot(0).func_77942_o()) {
                    passStack.func_77982_d(this.inventory.getStackInSlot(0).func_77978_p());
                }
                int slot = -1;
                for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                    if (handler.getStackInSlot(j).func_190926_b()) {
                        slot = j;
                        continue;
                    }
                    if (handler.getStackInSlot(j).func_190916_E() >= handler.getSlotLimit(j) || !ItemStack.func_179545_c((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0)) || !ItemStack.func_77970_a((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0))) continue;
                    slot = j;
                }
                if (slot == -1 || !(added = handler.insertItem(slot, passStack, false)).func_190926_b() || (extracted = this.inventory.extractItem(0, 1, false)).func_190926_b()) continue;
                if (tile instanceof TileEntityItemPipe) {
                    ((TileEntityItemPipe)tile).lastReceived = this.func_174877_v();
                }
                if (!toUpdate.contains(this.func_174877_v().func_177972_a(face))) {
                    toUpdate.add(this.func_174877_v().func_177972_a(face));
                }
                if (toUpdate.contains(this.func_174877_v())) continue;
                toUpdate.add(this.func_174877_v());
            }
        }
        for (i = 0; i < toUpdate.size(); ++i) {
            TileEntity tile = this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i));
            tile.func_70296_d();
            if (this.func_145831_w().field_72995_K || tile instanceof ITileEntityBase) continue;
            tile.func_70296_d();
            EventManager.markTEForUpdate((BlockPos)toUpdate.get(i), tile);
        }
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void setPressure(int pressure) {
        this.pressure = pressure;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

