/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;

public class TileEntityCrystalCell
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    Random random = new Random();
    public long ticksExisted = 0L;
    public float angle = 0.0f;
    public int ticksFueled = 0;
    public long seed = 0L;
    public IEmberCapability capability = new DefaultEmberCapability();
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityCrystalCell.this.func_70296_d();
            if (!TileEntityCrystalCell.this.func_145831_w().field_72995_K) {
                IBlockState state = TileEntityCrystalCell.this.func_145831_w().func_180495_p(TileEntityCrystalCell.this.func_174877_v());
                TileEntityCrystalCell.this.func_70296_d();
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() != RegistryManager.shard_ember && stack.func_77973_b() != RegistryManager.crystal_ember) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public boolean dirty = false;

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public TileEntityCrystalCell() {
        this.capability.setEmberCapacity(64000.0);
        this.seed = this.random.nextLong();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74772_a("seed", this.seed);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.capability.readFromNBT(tag);
        this.seed = tag.func_74763_f("seed");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.inventory.getStackInSlot(0) != ItemStack.field_190927_a && this.ticksExisted % 4L == 0L) {
            ItemStack stack = this.inventory.extractItem(0, 1, true);
            if (!this.func_145831_w().field_72995_K && stack != ItemStack.field_190927_a) {
                this.inventory.extractItem(0, 1, false);
                if (EmberGenUtil.getEmberForItem(stack.func_77973_b()) > 0.0) {
                    this.capability.setEmberCapacity(Math.min(1440000.0, this.capability.getEmberCapacity() + EmberGenUtil.getEmberForItem(stack.func_77973_b()) * 10.0));
                    this.func_70296_d();
                }
            }
            if (this.func_145831_w().field_72995_K && stack != ItemStack.field_190927_a) {
                double angle = this.random.nextDouble() * 2.0 * Math.PI;
                double x = (double)this.func_174877_v().func_177958_n() + 0.5 + 0.5 * Math.sin(angle);
                double z = (double)this.func_174877_v().func_177952_p() + 0.5 + 0.5 * Math.cos(angle);
                double x2 = (double)this.func_174877_v().func_177958_n() + 0.5;
                double z2 = (double)this.func_174877_v().func_177952_p() + 0.5;
                float layerHeight = 0.25f;
                float numLayers = 2.0f + (float)Math.floor(this.capability.getEmberCapacity() / 128000.0);
                float height = layerHeight * numLayers;
                for (float i = 0.0f; i < 72.0f; i += 1.0f) {
                    float coeff = i / 72.0f;
                    ParticleUtil.spawnParticleGlow(this.func_145831_w(), (float)x * (1.0f - coeff) + (float)x2 * coeff, (float)this.func_174877_v().func_177956_o() + (1.0f - coeff) + (height / 2.0f + 1.5f) * coeff, (float)z * (1.0f - coeff) + (float)z2 * coeff, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                }
            }
        }
        float numLayers = 2.0f + (float)Math.floor(this.capability.getEmberCapacity() / 128000.0);
        int i = 0;
        while ((float)i < numLayers / 2.0f) {
            float layerHeight = 0.25f;
            float height = layerHeight * numLayers;
            float xDest = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float yDest = (float)this.func_174877_v().func_177956_o() + height / 2.0f + 1.5f;
            float zDest = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float x = (float)this.func_174877_v().func_177958_n() + 0.5f + 2.0f * (this.random.nextFloat() - 0.5f);
            float z = (float)this.func_174877_v().func_177952_p() + 0.5f + 2.0f * (this.random.nextFloat() - 0.5f);
            float y = (float)this.func_174877_v().func_177956_o() + 1.0f;
            if (this.func_145831_w().field_72995_K) {
                ParticleUtil.spawnParticleGlow(this.func_145831_w(), x, y, z, (xDest - x) / 24.0f, (yDest - y) / 24.0f, (zDest - z) / 24.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
            }
            ++i;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        super.getCapability(capability, facing);
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return null;
    }
}

