/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.EventManager;
import teamroots.embers.block.BlockAxle;
import teamroots.embers.power.DefaultMechCapability;
import teamroots.embers.power.IMechCapability;
import teamroots.embers.power.MechCapabilityProvider;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityAxle
extends TileEntity
implements ITileEntityBase {
    int ticksExisted = 0;
    EnumFacing front = null;
    EnumFacing from = null;
    public DefaultMechCapability capability = new DefaultMechCapability(){

        @Override
        public void setPower(double value, EnumFacing face) {
            TileEntityAxle.this.from = face;
            super.setPower(value, face);
        }

        @Override
        public void onContentsChanged() {
            TileEntityAxle axle = TileEntityAxle.this;
            axle.updateNeighbors();
            axle.func_70296_d();
        }
    };
    public boolean dirty = false;

    public void updateNeighbors() {
        EnumFacing face;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockAxle) {
            this.front = Misc.getOppositeFace((EnumFacing)state.func_177229_b((IProperty)BlockAxle.facing));
            this.func_70296_d();
        }
        if (this.front != null && !this.func_145837_r()) {
            TileEntity lastTile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.front));
            if (lastTile == null) {
                this.capability.setPower(0.0, null);
                this.func_70296_d();
            } else if (!lastTile.hasCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(this.front))) {
                this.capability.setPower(0.0, null);
                this.func_70296_d();
            } else {
                this.capability.setPower(((IMechCapability)lastTile.getCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(this.front))).getPower(Misc.getOppositeFace(this.front)), this.front);
            }
        }
        if (state.func_177230_c() instanceof BlockAxle && (face = (EnumFacing)state.func_177229_b((IProperty)BlockAxle.facing)) != this.from) {
            TileEntity t;
            BlockPos p1 = this.func_174877_v().func_177972_a(face);
            BlockPos fromPos = null;
            if (this.front != null) {
                fromPos = this.func_174877_v().func_177972_a(this.front);
            }
            if (!(fromPos != null && (fromPos == null || p1.equals((Object)fromPos)) || (t = this.field_145850_b.func_175625_s(p1)) == null || !t.hasCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(face)) || t instanceof TileEntityAxle && ((TileEntityAxle)t).front == Misc.getOppositeFace(this.front))) {
                ((IMechCapability)t.getCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(face))).setPower(this.capability.getPower(face), Misc.getOppositeFace(face));
                t.func_70296_d();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        if (this.front != null) {
            tag.func_74768_a("front", this.front.func_176745_a());
        }
        if (this.from != null) {
            tag.func_74768_a("from", this.from.func_176745_a());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("front")) {
            this.front = EnumFacing.func_82600_a((int)tag.func_74762_e("front"));
        }
        if (tag.func_74764_b("from")) {
            this.from = EnumFacing.func_82600_a((int)tag.func_74762_e("from"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        EnumFacing face;
        IBlockState state;
        if (capability == MechCapabilityProvider.mechCapability && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() instanceof BlockAxle && (face = (EnumFacing)state.func_177229_b((IProperty)BlockAxle.facing)) != null && facing != null && face.func_176740_k() == facing.func_176740_k()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        System.out.println(this.front);
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        this.capability.setPower(0.0, null);
        this.updateNeighbors();
        world.func_175690_a(pos, null);
    }
}

