/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.particle.ParticleUtil;

public class MessageParticle
implements IMessage {
    String particleName = "";
    double x = 0.0;
    double y = 0.0;
    double z = 0.0;
    double vx = 0.0;
    double vy = 0.0;
    double vz = 0.0;
    double r = 0.0;
    double g = 0.0;
    double b = 0.0;

    public MessageParticle(String particleName, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b) {
        this.particleName = particleName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void fromBytes(ByteBuf buf) {
        this.particleName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.vx = buf.readDouble();
        this.vy = buf.readDouble();
        this.vz = buf.readDouble();
        this.r = buf.readDouble();
        this.g = buf.readDouble();
        this.b = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.particleName);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.vx);
        buf.writeDouble(this.vy);
        buf.writeDouble(this.vz);
        buf.writeDouble(this.r);
        buf.writeDouble(this.g);
        buf.writeDouble(this.b);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageParticle, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageParticle message, MessageContext ctx) {
            ParticleUtil.spawnParticlesFromPacket(message, FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_());
            return null;
        }
    }
}

