/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.VaultHelper;
import shetiphian.multistorage.common.tileentity.IVaultWall;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBaseDirectional;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBroken;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;
import shetiphian.multistorage.common.tileentity.TileEntityVaultGlass;
import shetiphian.multistorage.common.tileentity.TileEntityVaultItem;
import shetiphian.multistorage.common.tileentity.TileEntityVaultPower;
import shetiphian.multistorage.common.tileentity.TileEntityVaultRedstone;
import shetiphian.multistorage.common.tileentity.TileEntityVaultTank;

public class BlockVault
extends Block
implements IColored {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    private boolean checkThisBlock = false;

    public BlockVault() {
        super(Material.field_151576_e);
        this.func_149647_a((CreativeTabs)Values.tabMultiStorage);
        this.func_149752_b(6000000.0f);
        this.func_149713_g(255);
        this.func_149715_a(0.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT, COLOR}, new IUnlistedProperty[]{Properties.AnimationProperty});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockVault.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityVaultBase) {
            state = ((IVaultWall)tile).getActualState(state);
        } else if (tile instanceof TileEntityVaultBroken) {
            state = state.func_177226_a(VARIANT, (Comparable)((Object)((TileEntityVaultBroken)tile).getTypeBroken()));
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockVault.getEnumType(state);
        if ((type == EnumType.DOOR || type == EnumType.CORER) && state.func_177230_c() == this) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityVaultDoor) {
                return ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)((TileEntityVaultDoor)tile).getModelState());
            }
            if (tile instanceof TileEntityVaultCorer) {
                return ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)((TileEntityVaultCorer)tile).getModelState());
            }
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        EnumType type = BlockVault.getEnumType(state);
        return type.getTileClass() != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumType type = BlockVault.getEnumType(state);
        try {
            return type.getTileClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static TileEntityVaultBase getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityVaultBase ? (TileEntityVaultBase)tile : null;
    }

    public boolean func_149662_c(IBlockState state) {
        EnumType type = BlockVault.getEnumType(state);
        return type.getValue() < 13;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (state == null || world == null || pos == null || BlockVault.getEnumType(state) == EnumType.DOOR) {
            return -1.0f;
        }
        TileEntityVaultBase tile = BlockVault.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.isActive()) {
            return -1.0f;
        }
        return 2.5f;
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityVaultBase tile;
        if (state.func_177230_c() == this && (tile = BlockVault.getTile((IBlockAccess)world, pos)) != null) {
            if (tile instanceof TileEntityVaultDoor) {
                boolean remove;
                boolean bl = remove = ((TileEntityVaultDoor)tile).vaultDoorType == TileEntityVaultDoor.EnumDoorPart.NOTSET;
                if (!remove) {
                    TileEntity otherTile = world.func_175625_s(((TileEntityVaultDoor)tile).location);
                    boolean bl2 = remove = !(otherTile instanceof TileEntityVaultDoor);
                }
                if (remove) {
                    VaultHelper.removeDoorBlock((TileEntity)tile);
                }
                return false;
            }
            tile.verifyDoors();
            if (tile.isActive()) {
                return false;
            }
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        super.func_180657_a(world, player, pos, state, tile, stack);
        if (tile instanceof TileEntityVaultItem) {
            ((TileEntityVaultItem)tile).dropContent();
        }
        if (tile instanceof TileEntityVaultCorer) {
            ((TileEntityVaultCorer)tile).dropContent();
        }
        this.notifyRedstonePower(state, world, pos);
        super.removedByPlayer(state, world, pos, player, true);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityVaultRedstone) {
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    world.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
                }
            } else if (tile instanceof TileEntityVaultItem) {
                ((TileEntityVaultItem)tile).dropContent();
            } else if (tile instanceof TileEntityVaultCorer) {
                ((TileEntityVaultCorer)tile).dropContent();
            }
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return Configuration.SETTINGS.VAULT.pickupVaultBlocks > 0 && BlockVault.getEnumType(state).getDefaultItem() != null;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        ItemStack stack = super.func_180643_i(state);
        if (stack.func_77960_j() > 0 && stack.func_77960_j() < 14) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b(COLOR);
            stack.func_77983_a("color", (NBTBase)new NBTTagString(color.func_176610_l()));
            stack.func_77983_a("cvalue", (NBTBase)new NBTTagInt(color.field_193351_w));
        }
        return stack;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (BlockVault.getEnumType(state) == EnumType.DOOR) {
            world.func_175698_g(pos);
            if (placer instanceof EntityPlayer && !(placer instanceof FakePlayer)) {
                BlockPos doorPos;
                EntityPlayer player = (EntityPlayer)placer;
                if (VaultHelper.canPlayerPlaceDoor((EntityPlayer)placer) && (doorPos = VaultHelper.getDoorStart(world, pos, player)) != null) {
                    VaultHelper.placeDoor(world, doorPos, player, stack);
                    return;
                }
            }
            if (!stack.func_190926_b()) {
                stack = stack.func_77946_l();
                stack.func_190920_e(1);
            } else {
                stack = Values.stacks.get("vaultdoor", new int[0]);
            }
            Function.dropItem((World)world, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.notifyRedstonePower(state, world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        this.notifyRedstonePower(state, world, pos);
        super.func_189540_a(state, world, pos, neighbor, pos2);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = BlockVault.getEnumType(state = this.func_176221_a(state, world, pos));
        if (type == EnumType.CORER) {
            drops.add((Object)new ItemStack((Block)this, 1, (int)type.getValue()));
        } else if (type != EnumType.DOOR) {
            if (Configuration.SETTINGS.VAULT.pickupVaultBlocks == 2 && type.getValue() < 14) {
                ItemStack stack = new ItemStack((Block)this, 1, (int)type.getValue());
                EnumDyeColor color = (EnumDyeColor)state.func_177229_b(COLOR);
                stack.func_77983_a("color", (NBTBase)new NBTTagString(color.func_176610_l()));
                stack.func_77983_a("cvalue", (NBTBase)new NBTTagInt(color.field_193351_w));
                drops.add((Object)stack);
            } else {
                drops.add((Object)new ItemStack((Block)this, 1, type.getBaseValue() + 20));
            }
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumType type = BlockVault.getEnumType(state);
        return type != EnumType.DOOR && type != EnumType.CORER;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockVault.getEnumType(state);
        if (type == EnumType.DOOR) {
            return VaultHelper.getBlockBounds(world, pos);
        }
        return Block.field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Block.field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityVaultDoor) {
            return VaultHelper.onBlockActivated((TileEntityVaultDoor)tile, player);
        }
        if (tile instanceof TileEntityVaultCorer) {
            player.openGui((Object)MultiStorage.INSTANCE, 10, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (!world.field_72995_K && player.func_70093_af() && tile instanceof TileEntityVaultBaseDirectional && ((TileEntityVaultBaseDirectional)tile).canPlayerEdit(player)) {
            ((TileEntityVaultBaseDirectional)tile).setFacing(facing);
            return true;
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityVaultBase tile = BlockVault.getTile(world, pos);
        return tile instanceof TileEntityVaultRedstone;
    }

    private void notifyRedstonePower(IBlockState state, World world, BlockPos pos) {
        TileEntityVaultBase tile;
        if (!world.field_72995_K && this.canConnectRedstone(state, (IBlockAccess)world, pos, EnumFacing.DOWN) && (tile = BlockVault.getTile((IBlockAccess)world, pos)) instanceof TileEntityVaultRedstone) {
            TileEntityVaultRedstone wallTile = (TileEntityVaultRedstone)tile;
            int currentPower = wallTile.getPower();
            this.checkThisBlock = false;
            int powerIn = world.func_175676_y(pos);
            this.checkThisBlock = true;
            int newPower = MathHelper.func_76125_a((int)powerIn, (int)0, (int)15);
            if (currentPower != newPower) {
                wallTile.setPower(newPower);
                Function.syncTile((TileEntity)wallTile);
                world.func_175685_c(pos, (Block)this, true);
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    world.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
                }
            }
        }
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !this.checkThisBlock ? 0 : this.func_180656_a(state, world, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.canConnectRedstone(state, world, pos, side) && this.checkThisBlock) {
            TileEntityVaultBase tile = BlockVault.getTile(world, pos);
            return tile instanceof TileEntityVaultRedstone ? ((TileEntityVaultRedstone)tile).getPower() - 1 : 0;
        }
        return 0;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (Configuration.SETTINGS.VAULT.alwaysWitherProof) {
            return false;
        }
        TileEntityVaultBase tile = BlockVault.getTile(world, pos);
        return tile == null || !tile.isActive();
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockVault.getEnumType(state);
        return type == EnumType.DOOR ? 1 : (type == EnumType.CORER ? 15 : 100);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tile;
        EnumType type = BlockVault.getEnumType(state);
        if (type == EnumType.CORER && (tile = world.func_175625_s(pos)) instanceof TileEntityVaultCorer) {
            TileEntityVaultCorer corer = (TileEntityVaultCorer)tile;
            double posX = pos.func_177958_n();
            double posY = pos.func_177956_o();
            double posZ = pos.func_177952_p();
            if (corer.getStage() == TileEntityVaultCorer.EnumStage.CHARGING) {
                posY += rand.nextDouble() / 4.0 + (corer.getFacing() == EnumFacing.UP ? 0.1 : 0.7);
                if (corer.getFacing().func_176740_k() == EnumFacing.Axis.Y) {
                    posX += 0.1;
                    posZ += corer.getFacing() == EnumFacing.DOWN ? 0.3 : 0.7;
                } else {
                    posX += corer.getFacing() == EnumFacing.EAST || corer.getFacing() == EnumFacing.NORTH ? 0.2 : 0.8;
                    posZ += corer.getFacing() == EnumFacing.EAST || corer.getFacing() == EnumFacing.SOUTH ? 0.2 : 0.8;
                }
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, posX, posY, posZ, 0.0, 0.0, 0.0, new int[0]);
            } else if (corer.getStage() == TileEntityVaultCorer.EnumStage.WORKING) {
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, posX + rand.nextDouble(), posY + rand.nextDouble(), posZ + rand.nextDouble(), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)this.func_176223_P())});
            }
        }
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntityVaultBase tile = BlockVault.getTile((IBlockAccess)world, pos);
        return tile != null && tile.recolor(side, color);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isWindow(BlockVault.getEnumType(state)) && super.func_149686_d(state);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockVault.getEnumType(state).value > 12 ? 0 : 255;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        EnumType type = BlockVault.getEnumType(state);
        if (layer == BlockRenderLayer.CUTOUT) {
            return type != EnumType.DOOR && type != EnumType.WALL_NORMAL && type != EnumType.CORER;
        }
        return !this.isWindow(type) && layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 1 && data.world != null && data.pos != null) {
            IBlockState state;
            EnumType type;
            TileEntity tile = data.world.func_175625_s(data.pos);
            if (tile instanceof TileEntityVaultRedstone) {
                int power = ((TileEntityVaultRedstone)tile).getPower();
                int value = 255 - (15 - power) * 12;
                return (value << 16) + (value << 8) + value;
            }
            if (tile instanceof TileEntityVaultBroken && (type = BlockVault.getEnumType(state = data.state.func_177230_c().func_176221_a(data.state, data.world, data.pos))) == EnumType.WALL_REDSTONE_BROKEN) {
                return 0x4B4B4B;
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return this.isWindow(BlockVault.getEnumType(state));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState oState;
        EnumType type = BlockVault.getEnumType(state);
        if (this.isWindow(type) && (oState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c() == this && this.isWindow(BlockVault.getEnumType(oState))) {
            return false;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    private boolean isWindow(EnumType type) {
        return type.getValue() == 13 || type == EnumType.WALL_WINDOW_BROKEN;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        EnumType type = BlockVault.getEnumType(state = this.func_176221_a(state, (IBlockAccess)world, pos));
        ItemStack stack = new ItemStack((Block)this, 1, type.getValue() == 14 ? type.getBaseValue() + 20 : type.getValue());
        if (stack.func_77960_j() > 0 && stack.func_77960_j() < 14) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b(COLOR);
            stack.func_77983_a("color", (NBTBase)new NBTTagString(color.func_176610_l()));
            stack.func_77983_a("cvalue", (NBTBase)new NBTTagInt(color.field_193351_w));
        }
        return stack;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.WALL_NORMAL;
            MultiStorage.errorPropertyNotFound("BlockVault.VARIANT", "WALL_NORMAL", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        DOOR(0, TileEntityVaultDoor.class, null),
        WALL_NORMAL(1, TileEntityVaultBase.class, new ItemStack(Blocks.field_150411_aY)),
        WALL_ITEM(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_ITEM_DOWN(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_ITEM_UP(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_ITEM_NORTH(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_ITEM_SOUTH(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_ITEM_WEST(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_ITEM_EAST(2, TileEntityVaultItem.class, new ItemStack((Block)Blocks.field_150438_bZ)),
        WALL_REDSTONE(3, TileEntityVaultRedstone.class, new ItemStack(Blocks.field_150451_bX)),
        WALL_FLUID(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_FLUID_DOWN(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_FLUID_UP(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_FLUID_NORTH(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_FLUID_SOUTH(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_FLUID_WEST(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_FLUID_EAST(4, TileEntityVaultTank.class, new ItemStack((Block)Blocks.field_150383_bp)),
        WALL_POWER_EU(5, null, null),
        WALL_POWER_RF(6, null, null),
        WALL_POWER_CAPS(7, TileEntityVaultPower.class, null),
        WALL_WINDOW(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_WINDOW_DOWN(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_WINDOW_UP(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_WINDOW_NORTH(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_WINDOW_SOUTH(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_WINDOW_WEST(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_WINDOW_EAST(13, TileEntityVaultGlass.class, new ItemStack(Blocks.field_150359_w)),
        WALL_NORMAL_BROKEN(14, null, null),
        WALL_ITEM_BROKEN(14, null, null),
        WALL_REDSTONE_BROKEN(14, null, null),
        WALL_FLUID_BROKEN(14, null, null),
        WALL_POWER_EU_BROKEN(14, null, null),
        WALL_POWER_RF_BROKEN(14, null, null),
        WALL_POWER_CAPS_BROKEN(14, null, null),
        WALL_WINDOW_BROKEN(14, null, null),
        CORER(15, null, null);

        private static final EnumType[] array;
        private final byte value;
        private Class<? extends TileEntity> tile;
        private ItemStack defaultItem;

        private <T extends TileEntity> EnumType(int value, Class<T> tile, ItemStack defaultItem) {
            this.value = (byte)value;
            this.tile = tile;
            this.defaultItem = defaultItem;
        }

        public <T extends TileEntity> void setTile(Class<T> tile) {
            if (this.tile == null && tile != null) {
                this.tile = tile;
            }
        }

        public byte getValue() {
            return this.value;
        }

        public byte getBaseValue() {
            if (this.value == 14) {
                return EnumType.byName((String)this.func_176610_l().substring((int)0, (int)(this.func_176610_l().length() - 7))).value;
            }
            return this.value;
        }

        public Class<? extends TileEntity> getTileClass() {
            if (this.value == 14) {
                return TileEntityVaultBroken.class;
            }
            if (this.value == 15) {
                return TileEntityVaultCorer.class;
            }
            return this.tile != null ? this.tile : TileEntityVaultBase.class;
        }

        public ItemStack getDefaultItem() {
            return this.defaultItem != null ? this.defaultItem.func_77946_l() : null;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? WALL_NORMAL : type;
        }

        public static EnumType byName(String name) {
            for (EnumType value : EnumType.values()) {
                if (!value.toString().equalsIgnoreCase(name)) continue;
                return value;
            }
            return WALL_NORMAL;
        }

        public EnumType withFacing(EnumFacing facing) {
            String name = this.func_176610_l() + "_" + facing.func_176610_l();
            for (EnumType value : EnumType.values()) {
                if (!value.toString().equalsIgnoreCase(name)) continue;
                return value;
            }
            return this;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            for (EnumType type : EnumType.values()) {
                if (array[type.value] != null) continue;
                EnumType.array[type.value] = type;
            }
        }
    }
}

