/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.config.ConfigBase;
import net.silentchaos512.lib.proxy.IProxy;
import net.silentchaos512.lib.registry.SRegistry;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.LogHelper;

public abstract class AbstractModBase {
    public LocalizationHelper localization;
    public LogHelper log;
    public Random rand = new Random();
    public SRegistry registry;
    public IProxy proxy;
    public ConfigBase config;

    public AbstractModBase() {
        this.log = new LogHelper(this.getModName(), this.getBuildNum());
        this.registry = new SRegistry(this.getModId(), this.log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.localization = new LocalizationHelper(this.getModId()).setReplaceAmpersand(true);
        SilentLib.instance.registerLocalizationHelperForMod(this.getModId(), this.localization);
        this.config = this.getConfig();
        if (this.config != null) {
            this.config.init(event.getSuggestedConfigurationFile());
        }
        this.addPhasedInitializers();
        this.addRegistrationHandlers();
        this.onPreInit(event);
        this.proxy.preInit(this.registry, event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.onInit(event);
        if (this.config != null) {
            this.config.save();
        }
        this.proxy.init(this.registry, event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.onPostInit(event);
        this.proxy.postInit(this.registry, event);
    }

    protected abstract void addPhasedInitializers();

    protected abstract void addRegistrationHandlers();

    protected abstract void onPreInit(FMLPreInitializationEvent var1);

    protected abstract void onInit(FMLInitializationEvent var1);

    protected abstract void onPostInit(FMLPostInitializationEvent var1);

    public abstract String getModId();

    public abstract String getModName();

    public abstract int getBuildNum();

    @Nullable
    protected abstract ConfigBase getConfig();
}

