/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.math;

public class Ticks {
    public static final long SECOND = 20L;
    public static final long TICK_MS = 50L;
    public static final long MINUTE = 1200L;
    public static final long HOUR = 72000L;
    public static final long DAY = 1728000L;
    public static final long WEEK = 12096000L;

    public static long tms(long ticks) {
        return ticks * 50L;
    }

    public static long mst(long millis) {
        return millis / 50L;
    }

    public static long ts(long ticks) {
        return ticks / 20L;
    }

    public static long st(long seconds) {
        return seconds * 20L;
    }

    public static long tm(long ticks) {
        return ticks / 1200L;
    }

    public static long mt(long mintes) {
        return mintes * 1200L;
    }

    public static long th(long ticks) {
        return ticks / 72000L;
    }

    public static long ht(long hours) {
        return hours * 72000L;
    }

    public static long td(long ticks) {
        return ticks / 1728000L;
    }

    public static long dt(long days) {
        return days * 1728000L;
    }

    public static long tw(long ticks) {
        return ticks / 12096000L;
    }

    public static long wt(long weeks) {
        return weeks * 12096000L;
    }

    public static String toString(long timer) {
        long ticks;
        boolean hasTicks;
        boolean hasSeconds;
        boolean hasMinutes;
        boolean hasHours;
        boolean hasDays;
        boolean hasWeeks;
        if (timer <= 0L) {
            return "0s";
        }
        StringBuilder builder = new StringBuilder();
        if (timer < 20L) {
            builder.append(timer);
            builder.append('t');
            return builder.toString();
        }
        long weeks = Ticks.tw(timer);
        boolean bl = hasWeeks = weeks > 0L;
        if (hasWeeks) {
            builder.append(weeks);
            builder.append('w');
        }
        long days = Ticks.td(timer) % 7L;
        boolean bl2 = hasDays = hasWeeks || days != 0L;
        if (days != 0L) {
            if (hasWeeks) {
                builder.append(' ');
            }
            builder.append(days);
            builder.append('d');
        }
        long hours = Ticks.th(timer) % 24L;
        boolean bl3 = hasHours = hasDays || hours != 0L;
        if (hours != 0L) {
            if (hasDays) {
                builder.append(' ');
            }
            builder.append(hours);
            builder.append('h');
        }
        long minutes = Ticks.tm(timer) % 60L;
        boolean bl4 = hasMinutes = hasHours || minutes != 0L;
        if (minutes != 0L) {
            if (hasHours) {
                builder.append(' ');
            }
            builder.append(minutes);
            builder.append('m');
        }
        long seconds = Ticks.ts(timer) % 60L;
        boolean bl5 = hasSeconds = hasMinutes || seconds != 0L;
        if (seconds != 0L) {
            if (hasMinutes) {
                builder.append(' ');
            }
            builder.append(seconds);
            builder.append('s');
        }
        boolean bl6 = hasTicks = (ticks = timer % 20L) != 0L;
        if (ticks != 0L) {
            if (hasSeconds) {
                builder.append(' ');
            }
            builder.append(ticks);
            builder.append('t');
        }
        return builder.toString();
    }

    public static long fromString(String value) throws NumberFormatException {
        if (value.isEmpty() || value.equals("0s")) {
            return 0L;
        }
        long timer = 0L;
        block8: for (String s : value.split(" ")) {
            if (s.isEmpty()) continue;
            switch (s.charAt(s.length() - 1)) {
                case 'T': 
                case 't': {
                    timer += Long.parseLong(s.substring(0, s.length() - 1));
                    continue block8;
                }
                case 'S': 
                case 's': {
                    timer += Ticks.st(Long.parseLong(s.substring(0, s.length() - 1)));
                    continue block8;
                }
                case 'M': 
                case 'm': {
                    timer += Ticks.mt(Long.parseLong(s.substring(0, s.length() - 1)));
                    continue block8;
                }
                case 'H': 
                case 'h': {
                    timer += Ticks.ht(Long.parseLong(s.substring(0, s.length() - 1)));
                    continue block8;
                }
                case 'D': 
                case 'd': {
                    timer += Ticks.dt(Long.parseLong(s.substring(0, s.length() - 1)));
                    continue block8;
                }
                case 'W': 
                case 'w': {
                    timer += Ticks.wt(Long.parseLong(s.substring(0, s.length() - 1)));
                    continue block8;
                }
                default: {
                    timer += Long.parseLong(s);
                }
            }
        }
        return timer;
    }
}

