/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.MutableColor4I;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class BulletIcon
extends Icon {
    private static final MutableColor4I DEFAULT_COLOR = Color4I.rgb(0xEDEDED).mutable();
    private static final MutableColor4I DEFAULT_COLOR_B = Color4I.rgb(0xFFFFFF).mutable();
    private static final MutableColor4I DEFAULT_COLOR_D = Color4I.rgb(0xDDDDDD).mutable();
    private Color4I color = Icon.EMPTY;
    private Color4I colorB = Icon.EMPTY;
    private Color4I colorD = Icon.EMPTY;
    private boolean inversed;

    public BulletIcon setColor(Color4I col) {
        this.color = col;
        if (this.color.isEmpty()) {
            return this;
        }
        MutableColor4I c = this.color.mutable();
        c.addBrightness(18);
        this.colorB = c.copy();
        c = this.color.mutable();
        c.addBrightness(-18);
        this.colorD = c.copy();
        return this;
    }

    public BulletIcon setInversed(boolean v) {
        this.inversed = v;
        return this;
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        Color4I cd;
        Color4I cb;
        Color4I c;
        if (!col.isEmpty()) {
            c = col;
            MutableColor4I cm = col.mutable();
            cm.addBrightness(18);
            cb = cm.copy();
            cm = col.mutable();
            cm.addBrightness(-18);
            cd = cm.copy();
        } else if (this.color.isEmpty()) {
            c = DEFAULT_COLOR;
            cb = DEFAULT_COLOR_B;
            cd = DEFAULT_COLOR_D;
        } else {
            c = this.color;
            cb = this.colorB;
            cd = this.colorD;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 2, this.inversed ? cd : cb);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, this.inversed ? cb : cd);
        GuiHelper.addRectToBuffer(buffer, x + 1, y, w - 2, 1, this.inversed ? cd : cb);
        GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 2, 1, this.inversed ? cb : cd);
        GuiHelper.addRectToBuffer(buffer, x + 1, y + 1, w - 2, h - 2, c);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", "bullet");
        if (!this.color.isEmpty()) {
            o.add("color", this.color.getJson());
        }
        return o;
    }
}

