/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.TextBox;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Icon;

public abstract class GuiButtonListBase
extends GuiBase {
    private final Panel panelButtons = new Panel(this){

        @Override
        public void add(Widget widget) {
            if (!GuiButtonListBase.this.hasSearchBox || GuiButtonListBase.this.getFilterText(widget).toLowerCase().contains(GuiButtonListBase.this.textBox.getText().toLowerCase())) {
                super.add(widget);
            }
        }

        @Override
        public void addWidgets() {
            GuiButtonListBase.this.addButtons(this);
        }

        @Override
        public void alignWidgets() {
            boolean size = false;
            this.setY(GuiButtonListBase.this.hasSearchBox ? 23 : 9);
            int prevWidth = this.width;
            if (this.widgets.isEmpty()) {
                this.setWidth(100);
            } else {
                this.setWidth(0);
                for (Widget w : this.widgets) {
                    this.setWidth(Math.max(this.width, w.width));
                }
            }
            if (GuiButtonListBase.this.hasSearchBox) {
                this.setWidth(Math.max(this.width, prevWidth));
            }
            for (Widget w : this.widgets) {
                w.setWidth(this.width);
            }
            this.setHeight(140);
            GuiButtonListBase.this.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
            GuiButtonListBase.this.scrollBar.setMaxValue(this.align(WidgetLayout.VERTICAL));
            this.getGui().setWidth(((GuiButtonListBase)GuiButtonListBase.this).scrollBar.posX + ((GuiButtonListBase)GuiButtonListBase.this).scrollBar.width + 8);
            this.getGui().setHeight(this.height + 18 + (GuiButtonListBase.this.hasSearchBox ? 14 : 0));
            if (GuiButtonListBase.this.hasSearchBox) {
                GuiButtonListBase.this.textBox.setPosAndSize(8, 6, this.getGui().width - 16, 12);
            }
        }

        @Override
        public Icon getIcon() {
            return this.getTheme().getPanelBackground();
        }
    };
    private final PanelScrollBar scrollBar;
    private String title = "";
    private TextBox textBox;
    private boolean hasSearchBox;

    public GuiButtonListBase() {
        this.panelButtons.setPosAndSize(9, 9, 0, 146);
        this.scrollBar = new PanelScrollBar(this, this.panelButtons);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20);
        this.textBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                GuiButtonListBase.this.panelButtons.refreshWidgets();
            }
        };
        this.hasSearchBox = false;
    }

    public void setHasSearchBox(boolean v) {
        if (this.hasSearchBox != v) {
            this.hasSearchBox = v;
            this.refreshWidgets();
        }
    }

    public String getFilterText(Widget widget) {
        return widget.getTitle();
    }

    @Override
    public void addWidgets() {
        this.add(this.panelButtons);
        this.add(this.scrollBar);
        if (this.hasSearchBox) {
            this.add(this.textBox);
        }
    }

    @Override
    public void alignWidgets() {
        this.panelButtons.alignWidgets();
    }

    public abstract void addButtons(Panel var1);

    public void setTitle(String txt) {
        this.title = txt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void drawBackground() {
        super.drawBackground();
        String title = this.getTitle();
        if (!title.isEmpty()) {
            this.drawString(title, this.getAX() + (this.width - this.getStringWidth(title)) / 2, this.getAY() - this.getFontHeight() - 2, 2);
        }
    }
}

