/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import java.util.List;

public class TextField
extends Widget {
    public String[] text = StringUtils.EMPTY_ARRAY;
    public int textFlags = 0;
    public boolean autoSizeWidth = true;
    public boolean autoSizeHeight = true;

    public TextField(Panel panel, String txt, int flags) {
        super(panel);
        this.textFlags = flags;
        this.setText(txt);
    }

    public TextField(Panel panel, String txt) {
        this(panel, txt, 0);
    }

    public TextField setText(String txt) {
        this.text = null;
        if (!txt.isEmpty()) {
            String[] stringArray = this.text = this.autoSizeWidth ? txt.split("\n") : this.listFormattedStringToWidth(txt, this.width).toArray(StringUtils.EMPTY_ARRAY);
        }
        if (this.text == null || this.text.length == 0) {
            this.text = StringUtils.EMPTY_ARRAY;
        }
        if (this.autoSizeWidth) {
            this.setWidth(0);
            for (String s : this.text) {
                this.setWidth(Math.max(this.width, this.getStringWidth(s)));
            }
        }
        if (this.autoSizeHeight) {
            this.setHeight(Math.max(this.text.length, 1) * (this.getFontHeight() + 1));
        }
        return this;
    }

    @Override
    public void addMouseOverText(List<String> list) {
    }

    @Override
    public void draw() {
        int ay = this.getAY();
        int ax = this.getAX();
        this.getIcon().draw(ax, ay, this.width, this.height);
        if (this.text.length == 0) {
            return;
        }
        for (int i = 0; i < this.text.length; ++i) {
            this.drawString(this.text[i], ax, ay + i * 10 + 1, this.textFlags);
        }
    }
}

