/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiWrapper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.NetUtils;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends Panel {
    private final FontRenderer font;
    private int mouseX;
    private int mouseY;
    private boolean refreshWidgets;
    private ScaledResolution screen;
    public boolean fixUnicode;
    private GuiScreen prevScreen;
    private final BooleanStack fontUnicode;
    private Theme theme;
    public static boolean renderDebugBoxes = false;

    public GuiBase() {
        super(null);
        this.setSize(176, 166);
        this.setOnlyRenderWidgetsInside(false);
        this.setOnlyInteractWithWidgetsInside(false);
        this.font = this.createFont();
        this.prevScreen = ClientUtils.MC.field_71462_r;
        this.fontUnicode = new BooleanArrayList();
    }

    @Override
    public final GuiBase getGui() {
        return this;
    }

    @Override
    public void alignWidgets() {
    }

    public final void initGui() {
        this.screen = new ScaledResolution(ClientUtils.MC);
        if (this.onInit()) {
            super.refreshWidgets();
            this.fixUnicode = this.screen.func_78325_e() % 2 == 1;
            this.alignWidgets();
            this.onPostInit();
        }
    }

    @Override
    public Theme getTheme() {
        if (this.theme == null) {
            this.theme = this.createTheme();
        }
        return this.theme;
    }

    protected Theme createTheme() {
        return Theme.DEFAULT;
    }

    @Override
    public int getAX() {
        return (this.screen.func_78326_a() - this.width) / 2;
    }

    @Override
    public int getAY() {
        return (this.screen.func_78328_b() - this.height) / 2;
    }

    @Override
    public void setScrollX(int scroll) {
    }

    @Override
    public void setScrollY(int scroll) {
    }

    @Override
    public int getScrollX() {
        return 0;
    }

    @Override
    public int getScrollY() {
        return 0;
    }

    public boolean onInit() {
        return true;
    }

    protected boolean setFullscreen() {
        this.setWidth(this.screen.func_78326_a());
        this.setHeight(this.screen.func_78328_b());
        return true;
    }

    public void onPostInit() {
    }

    @Nullable
    public GuiScreen getPrevScreen() {
        if (this.prevScreen instanceof GuiWrapper && ((GuiWrapper)this.prevScreen).getGui() instanceof GuiLoading) {
            return ((GuiWrapper)this.prevScreen).getGui().getPrevScreen();
        }
        if (this.prevScreen instanceof GuiChat) {
            return null;
        }
        return this.prevScreen;
    }

    public final void closeGui() {
        this.closeGui(true);
    }

    public final void closeGui(boolean openPrevScreen) {
        int mx = Mouse.getX();
        int my = Mouse.getY();
        if (ClientUtils.MC.field_71439_g != null) {
            ClientUtils.MC.field_71439_g.func_71053_j();
            if (ClientUtils.MC.field_71462_r == null) {
                ClientUtils.MC.func_71381_h();
            }
        }
        if (openPrevScreen) {
            ClientUtils.MC.func_147108_a(this.getPrevScreen());
            Mouse.setCursorPosition((int)mx, (int)my);
        }
        this.onClosed();
    }

    public boolean onClosedByKey(int key) {
        return key == 1 || ClientUtils.MC.field_71474_y.field_151445_Q.isActiveAndMatches(key);
    }

    public void onClosed() {
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public FontRenderer getFont() {
        return this.font;
    }

    protected FontRenderer createFont() {
        return ClientUtils.MC.field_71466_p;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my) {
        this.mouseX = mx;
        this.mouseY = my;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.posX = this.getAX();
        this.posY = this.getAY();
        this.updateMouseOver(this.mouseX, this.mouseY);
    }

    @Override
    public final void draw() {
        GuiHelper.setupDrawing();
        super.draw();
    }

    @Override
    protected final void drawPanelBackground(int ax, int ay) {
    }

    public boolean drawDefaultBackground() {
        return true;
    }

    public void drawBackground() {
        this.getTheme().getGui(WidgetType.NORMAL).draw(this.getAX(), this.getAY(), this.width, this.height);
    }

    public void drawForeground() {
        ArrayList<String> tempTextList = new ArrayList<String>(0);
        this.addMouseOverText(tempTextList);
        GuiUtils.drawHoveringText(tempTextList, (int)this.mouseX, (int)Math.max(this.mouseY, 18), (int)this.screen.func_78326_a(), (int)this.screen.func_78328_b(), (int)0, (FontRenderer)this.getFont());
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        boolean b = super.keyPressed(key, keyChar);
        if (!b && FTBLibConfig.debugging.gui_widget_bounds && key == 48) {
            renderDebugBoxes = !renderDebugBoxes;
            b = true;
        }
        return b;
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return true;
    }

    public GuiScreen getWrapper() {
        return new GuiWrapper(this);
    }

    public final void openGui() {
        ClientUtils.MC.func_147108_a(this.getWrapper());
    }

    public final void openGuiLater() {
        ClientUtils.runLater(this::openGui);
    }

    @Override
    public final ScaledResolution getScreen() {
        return this.screen;
    }

    @Override
    public final int getMouseX() {
        return this.mouseX;
    }

    @Override
    public final int getMouseY() {
        return this.mouseY;
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget widget) {
        if (widget == this) {
            return this.isMouseOver(this.getAX(), this.getAY(), this.width, this.height);
        }
        if (this.isMouseOver(widget.getAX(), widget.getAY(), widget.width, widget.height)) {
            boolean offset = widget.parent.isOffset();
            widget.parent.setOffset(false);
            boolean b = this.isMouseOver(widget.parent);
            widget.parent.setOffset(offset);
            return b;
        }
        return false;
    }

    @Override
    public void pushFontUnicode(boolean flag) {
        this.fontUnicode.push(this.getFont().func_82883_a());
        this.getFont().func_78264_a(flag);
    }

    @Override
    public void popFontUnicode() {
        this.getFont().func_78264_a(((Boolean)this.fontUnicode.pop()).booleanValue());
    }

    @Override
    public Icon getIcon() {
        return Icon.EMPTY;
    }

    @Override
    public boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                try {
                    URI uri = new URI(scheme + ':' + path);
                    if (ClientUtils.MC.field_71474_y.field_74358_q) {
                        GuiScreen currentScreen = ClientUtils.MC.field_71462_r;
                        ClientUtils.MC.func_147108_a((GuiScreen)new GuiConfirmOpenLink((result, id) -> {
                            if (result) {
                                try {
                                    NetUtils.openURI(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ClientUtils.MC.func_147108_a(currentScreen);
                        }, scheme + ':' + path, 0, false));
                    } else {
                        NetUtils.openURI(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "file": {
                try {
                    NetUtils.openURI(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "custom": {
                return new CustomClickEvent(new ResourceLocation(path)).post();
            }
        }
        return false;
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final ClickEvent clickEvent;
        public final HoverEvent hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, Style s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.func_150235_h();
            this.hoverEvent = s.func_150210_i();
            this.insertion = s.func_179986_j();
        }
    }
}

