/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.data;

import com.feed_the_beast.ftblib.lib.data.IHasCache;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTDataStorage
implements INBTSerializable<NBTTagCompound>,
IHasCache {
    public static final NBTDataStorage EMPTY = new NBTDataStorage(){

        @Override
        @Nullable
        public INBTSerializable<NBTTagCompound> getRaw(String id) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
        }
    };
    private final Map<String, INBTSerializable<NBTTagCompound>> map = new HashMap<String, INBTSerializable<NBTTagCompound>>();

    public void add(String id, INBTSerializable<NBTTagCompound> data) {
        this.map.put(id, data);
    }

    @Nullable
    public INBTSerializable<NBTTagCompound> getRaw(String id) {
        return this.map.get(id);
    }

    public <T extends INBTSerializable<NBTTagCompound>> T get(String id) {
        return (T)((INBTSerializable)CommonUtils.cast(Objects.requireNonNull(this.getRaw(id))));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, INBTSerializable<NBTTagCompound>> entry : this.map.entrySet()) {
            NBTTagCompound nbt1 = (NBTTagCompound)entry.getValue().serializeNBT();
            if (nbt1.func_82582_d()) continue;
            nbt.func_74782_a(entry.getKey(), (NBTBase)nbt1);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        CommonUtils.renameTag(nbt, "ftbl:data", "ftblib");
        CommonUtils.renameTag(nbt, "ftbl", "ftblib");
        CommonUtils.renameTag(nbt, "ftbu:data", "ftbutilities");
        CommonUtils.renameTag(nbt, "ftbu", "ftbutilities");
        for (Map.Entry<String, INBTSerializable<NBTTagCompound>> entry : this.map.entrySet()) {
            entry.getValue().deserializeNBT((NBTBase)nbt.func_74775_l(entry.getKey()));
        }
    }

    @Override
    public void clearCache() {
        for (Map.Entry<String, INBTSerializable<NBTTagCompound>> entry : this.map.entrySet()) {
            if (!(entry.getValue() instanceof IHasCache)) continue;
            ((IHasCache)entry.getValue()).clearCache();
        }
    }
}

