/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.data;

import com.feed_the_beast.ftblib.events.team.ForgeTeamConfigEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamOwnerChangedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.EnumTeamStatus;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.IHasCache;
import com.feed_the_beast.ftblib.lib.data.NBTDataStorage;
import com.feed_the_beast.ftblib.lib.data.TeamType;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.INBTSerializable;

public class ForgeTeam
extends FinalIDObject
implements IStringSerializable,
INBTSerializable<NBTTagCompound>,
IHasCache {
    public final Universe universe;
    public final TeamType type;
    public ForgePlayer owner;
    public final NBTDataStorage dataStorage;
    private final ConfigString title;
    private final ConfigString desc;
    private final ConfigEnum<EnumTeamColor> color;
    private final ConfigString icon;
    private final ConfigBoolean freeToJoin;
    private final ConfigEnum<EnumTeamStatus> fakePlayerStatus;
    private final Collection<ForgePlayer> requestingInvite;
    public final Map<ForgePlayer, EnumTeamStatus> players;
    private ConfigGroup cachedConfig;
    private ITextComponent cachedTitle;
    private IConfigCallback cachedConfigCallback;
    private Icon cachedIcon;
    public boolean needsSaving;

    public ForgeTeam(Universe u, String id, TeamType t) {
        super(id, t.isNone ? 0 : 15);
        this.universe = u;
        this.type = t;
        this.title = new ConfigString("");
        this.desc = new ConfigString("");
        this.color = new ConfigEnum<EnumTeamColor>(EnumTeamColor.NAME_MAP);
        this.icon = new ConfigString("");
        this.freeToJoin = new ConfigBoolean(false);
        this.fakePlayerStatus = new ConfigEnum<EnumTeamStatus>(EnumTeamStatus.NAME_MAP_PERMS);
        this.requestingInvite = new HashSet<ForgePlayer>();
        this.players = new HashMap<ForgePlayer, EnumTeamStatus>();
        this.dataStorage = new NBTDataStorage();
        new ForgeTeamDataEvent(this, this.dataStorage::add).post();
        this.clearCache();
        this.cachedIcon = null;
        this.needsSaving = false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.owner != null) {
            nbt.func_74778_a("Owner", this.owner.func_176610_l());
        }
        nbt.func_74778_a("Title", this.title.getString());
        nbt.func_74778_a("Desc", this.desc.getString());
        nbt.func_74778_a("Color", this.color.getString());
        nbt.func_74778_a("Icon", this.icon.getString());
        nbt.func_74757_a("FreeToJoin", this.freeToJoin.getBoolean());
        nbt.func_74778_a("FakePlayerStatus", this.fakePlayerStatus.getString());
        NBTTagCompound nbt1 = new NBTTagCompound();
        if (!this.players.isEmpty()) {
            for (Map.Entry<ForgePlayer, EnumTeamStatus> entry : this.players.entrySet()) {
                nbt1.func_74778_a(entry.getKey().func_176610_l(), entry.getValue().func_176610_l());
            }
        }
        nbt.func_74782_a("Players", (NBTBase)nbt1);
        NBTTagList list = new NBTTagList();
        for (ForgePlayer player : this.requestingInvite) {
            list.func_74742_a((NBTBase)new NBTTagString(player.func_176610_l()));
        }
        nbt.func_74782_a("RequestingInvite", (NBTBase)list);
        nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        ForgePlayer player;
        int i;
        this.owner = this.universe.getPlayer(nbt.func_74779_i("Owner"));
        if (!this.isValid()) {
            return;
        }
        this.title.setString(nbt.func_74779_i("Title"));
        this.desc.setString(nbt.func_74779_i("Desc"));
        this.color.setValue(nbt.func_74779_i("Color"));
        this.icon.setString(nbt.func_74779_i("Icon"));
        this.freeToJoin.setBoolean(nbt.func_74767_n("FreeToJoin"));
        this.fakePlayerStatus.setValue(nbt.func_74779_i("FakePlayerStatus"));
        this.players.clear();
        if (nbt.func_74764_b("Players")) {
            NBTTagCompound nbt1 = nbt.func_74775_l("Players");
            for (String s : nbt1.func_150296_c()) {
                EnumTeamStatus status;
                ForgePlayer player2 = this.universe.getPlayer(s);
                if (player2 == null || !(status = EnumTeamStatus.NAME_MAP.get(nbt1.func_74779_i(s))).canBeSet()) continue;
                this.setStatus(player2, status);
            }
        }
        NBTTagList list = nbt.func_150295_c("RequestingInvite", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            player = this.universe.getPlayer(list.func_150307_f(i));
            if (player == null || this.isMember(player)) continue;
            this.setRequestingInvite(player, true);
        }
        list = nbt.func_150295_c("Invited", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            player = this.universe.getPlayer(list.func_150307_f(i));
            if (player == null || this.isMember(player)) continue;
            this.setStatus(player, EnumTeamStatus.INVITED);
        }
        this.dataStorage.deserializeNBT(nbt.func_74775_l("Data"));
    }

    @Override
    public void clearCache() {
        this.cachedTitle = null;
        this.cachedIcon = null;
        this.cachedConfig = null;
        this.cachedConfigCallback = null;
        this.dataStorage.clearCache();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.universe.checkSaving = true;
    }

    public <T extends INBTSerializable<NBTTagCompound>> T getData(String id) {
        return this.dataStorage.get(id);
    }

    public boolean hasOwner() {
        return this.type.isPlayer && this.owner != null;
    }

    public ITextComponent getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle;
        }
        this.cachedTitle = this.title.isEmpty() ? (this.hasOwner() ? this.owner.getDisplayName().func_150258_a("'s Team") : new TextComponentString("Unnamed")) : new TextComponentString(this.title.getString());
        this.cachedTitle = StringUtils.color(this.cachedTitle, this.getColor().getTextFormatting());
        return this.cachedTitle;
    }

    public void setTitle(String s) {
        if (!this.title.getString().equals(s)) {
            this.title.setString(s);
            this.markDirty();
        }
    }

    public String getDesc() {
        return this.desc.getString();
    }

    public void setDesc(String s) {
        if (!this.desc.getString().equals(s)) {
            this.desc.setString(s);
            this.markDirty();
        }
    }

    public EnumTeamColor getColor() {
        return this.color.getValue();
    }

    public void setColor(EnumTeamColor col) {
        if (this.color.getValue() != col) {
            this.color.setValue(col);
            this.markDirty();
        }
    }

    public Icon getIcon() {
        if (this.cachedIcon == null) {
            String iconstring = this.icon.getString();
            this.cachedIcon = iconstring.isEmpty() ? (this.hasOwner() ? new PlayerHeadIcon(this.owner.getProfile().getId()) : this.getColor().getColor()) : Icon.getIcon(iconstring);
        }
        return this.cachedIcon;
    }

    public void setIcon(String s) {
        if (!this.icon.getString().equals(s)) {
            this.icon.setString(s);
            this.markDirty();
        }
    }

    public boolean isFreeToJoin() {
        return this.freeToJoin.getBoolean();
    }

    public void setFreeToJoin(boolean b) {
        if (this.freeToJoin.getBoolean() != b) {
            this.freeToJoin.setBoolean(b);
            this.markDirty();
        }
    }

    public EnumTeamStatus getFakePlayerStatus() {
        return this.fakePlayerStatus.getValue();
    }

    public void setFakePlyerStatus(EnumTeamStatus status) {
        if (this.fakePlayerStatus.getValue() != status) {
            this.fakePlayerStatus.setValue(status);
            this.markDirty();
        }
    }

    public EnumTeamStatus getHighestStatus(@Nullable ForgePlayer player) {
        if (player == null) {
            return EnumTeamStatus.NONE;
        }
        if (player.isFake()) {
            return this.fakePlayerStatus.getValue();
        }
        if (this.isOwner(player)) {
            return EnumTeamStatus.OWNER;
        }
        if (this.isModerator(player)) {
            return EnumTeamStatus.MOD;
        }
        if (this.isMember(player)) {
            return EnumTeamStatus.MEMBER;
        }
        if (this.isEnemy(player)) {
            return EnumTeamStatus.ENEMY;
        }
        if (this.isAlly(player)) {
            return EnumTeamStatus.ALLY;
        }
        if (this.isInvited(player)) {
            return EnumTeamStatus.INVITED;
        }
        return EnumTeamStatus.NONE;
    }

    private EnumTeamStatus getSetStatus(@Nullable ForgePlayer player) {
        if (player == null || !this.isValid()) {
            return EnumTeamStatus.NONE;
        }
        if (player.isFake()) {
            return this.fakePlayerStatus.getValue();
        }
        EnumTeamStatus status = this.players.get(player);
        return status == null ? EnumTeamStatus.NONE : status;
    }

    public boolean hasStatus(@Nullable ForgePlayer player, EnumTeamStatus status) {
        if (player == null || !this.isValid()) {
            return false;
        }
        if (player.isFake()) {
            return this.getFakePlayerStatus().isEqualOrGreaterThan(status);
        }
        switch (status) {
            case NONE: {
                return true;
            }
            case ENEMY: {
                return this.isEnemy(player);
            }
            case ALLY: {
                return this.isAlly(player);
            }
            case INVITED: {
                return this.isInvited(player);
            }
            case MEMBER: {
                return this.isMember(player);
            }
            case MOD: {
                return this.isModerator(player);
            }
            case OWNER: {
                return this.isOwner(player);
            }
        }
        return false;
    }

    public boolean setStatus(@Nullable ForgePlayer player, EnumTeamStatus status) {
        if (player == null || !this.isValid() || player.isFake()) {
            return false;
        }
        if (status == EnumTeamStatus.OWNER) {
            if (!this.isMember(player)) {
                return false;
            }
            if (!player.equalsPlayer(this.owner)) {
                ForgePlayer oldOwner = this.owner;
                this.owner = player;
                this.players.remove(player);
                new ForgeTeamOwnerChangedEvent(this, oldOwner).post();
                if (oldOwner != null) {
                    oldOwner.markDirty();
                }
                this.owner.markDirty();
                this.markDirty();
                return true;
            }
            return false;
        }
        if (!status.isNone() && status.canBeSet()) {
            if (this.players.put(player, status) != status) {
                player.markDirty();
                this.markDirty();
                return true;
            }
        } else if (this.players.remove(player) != status) {
            player.markDirty();
            this.markDirty();
            return true;
        }
        return false;
    }

    public Collection<ForgePlayer> getPlayersWithStatus(Collection<ForgePlayer> collection, EnumTeamStatus status) {
        if (!this.isValid()) {
            return collection;
        }
        for (ForgePlayer player : this.universe.getPlayers()) {
            if (player.isFake() || !this.hasStatus(player, status)) continue;
            collection.add(player);
        }
        return collection;
    }

    public List<ForgePlayer> getPlayersWithStatus(EnumTeamStatus status) {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<ForgePlayer> list = new ArrayList<ForgePlayer>();
        this.getPlayersWithStatus(list, status);
        return list;
    }

    public boolean addMember(ForgePlayer player, boolean simulate) {
        if (this.isValid() && (this.isOwner(player) || this.isInvited(player)) && !this.isMember(player)) {
            if (!simulate) {
                player.team = this;
                this.players.remove(player);
                this.requestingInvite.remove(player);
                new ForgeTeamPlayerJoinedEvent(player).post();
                player.markDirty();
                this.markDirty();
            }
            return true;
        }
        return false;
    }

    public boolean removeMember(ForgePlayer player) {
        if (!this.isValid() || !this.isMember(player)) {
            return false;
        }
        if (this.getMembers().size() == 1) {
            new ForgeTeamPlayerLeftEvent(player).post();
            if (this.type.isPlayer) {
                File folder = new File(this.universe.getWorldDirectory(), "data/ftb_lib/teams/");
                new ForgeTeamDeletedEvent(this, folder).post();
                this.universe.teams.remove(this.func_176610_l());
                FileUtils.delete(new File(folder, this.func_176610_l() + ".dat"));
            } else {
                this.setStatus(player, EnumTeamStatus.NONE);
            }
            player.team = this.universe.getTeam("");
            player.markDirty();
            this.markDirty();
        } else if (this.isOwner(player)) {
            return false;
        }
        new ForgeTeamPlayerLeftEvent(player).post();
        player.team = this.universe.getTeam("");
        this.setStatus(player, EnumTeamStatus.NONE);
        player.markDirty();
        this.markDirty();
        return true;
    }

    public List<ForgePlayer> getMembers() {
        return this.getPlayersWithStatus(EnumTeamStatus.MEMBER);
    }

    public boolean isMember(@Nullable ForgePlayer player) {
        if (player == null) {
            return false;
        }
        if (player.isFake()) {
            return this.fakePlayerStatus.getValue().isEqualOrGreaterThan(EnumTeamStatus.MEMBER);
        }
        return this.isValid() && this.equalsTeam(player.team);
    }

    public boolean isAlly(@Nullable ForgePlayer player) {
        return this.isValid() && (this.isMember(player) || this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.ALLY));
    }

    public boolean isInvited(@Nullable ForgePlayer player) {
        return this.isValid() && (this.isMember(player) || (this.isFreeToJoin() || this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.INVITED)) && !this.isEnemy(player));
    }

    public boolean setRequestingInvite(@Nullable ForgePlayer player, boolean value) {
        if (player != null && this.isValid()) {
            if (value) {
                if (this.requestingInvite.add(player)) {
                    player.markDirty();
                    this.markDirty();
                    return true;
                }
            } else if (this.requestingInvite.remove(player)) {
                player.markDirty();
                this.markDirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isRequestingInvite(@Nullable ForgePlayer player) {
        return player != null && this.isValid() && !this.isMember(player) && this.requestingInvite.contains(player) && !this.isEnemy(player);
    }

    public boolean isEnemy(@Nullable ForgePlayer player) {
        return this.getSetStatus(player) == EnumTeamStatus.ENEMY;
    }

    public boolean isModerator(@Nullable ForgePlayer player) {
        return this.isOwner(player) || this.isMember(player) && this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.MOD);
    }

    public boolean isOwner(@Nullable ForgePlayer player) {
        return player != null && player.equalsPlayer(this.owner);
    }

    public ConfigGroup getSettings() {
        if (this.cachedConfig == null) {
            this.cachedConfig = new ConfigGroup((ITextComponent)new TextComponentTranslation("gui.settings", new Object[0]));
            this.cachedConfig.setSupergroup("team_config");
            ForgeTeamConfigEvent event = new ForgeTeamConfigEvent(this, this.cachedConfig);
            event.post();
            event.getConfig().setGroupName("ftblib", (ITextComponent)new TextComponentString("FTBLib"));
            event.getConfig().add("ftblib", "free_to_join", this.freeToJoin);
            event.getConfig().add("ftblib.display", "color", this.color);
            event.getConfig().add("ftblib.display", "fake_player_status", this.fakePlayerStatus);
            event.getConfig().add("ftblib.display", "title", this.title);
            event.getConfig().add("ftblib.display", "desc", this.desc);
        }
        return this.cachedConfig;
    }

    public IConfigCallback getConfigCallback() {
        if (this.cachedConfigCallback == null) {
            this.cachedConfigCallback = (group, sender, json) -> {
                group.func_152753_a((JsonElement)json);
                this.clearCache();
                this.markDirty();
            };
        }
        return this.cachedConfigCallback;
    }

    public boolean isValid() {
        if (this.type.isNone) {
            return false;
        }
        return this.type.isServer || this.hasOwner();
    }

    public boolean equalsTeam(@Nullable ForgeTeam team) {
        return team == this || team != null && this.func_176610_l().equals(team.func_176610_l());
    }

    public boolean anyPlayerHasPermission(String permission, EnumTeamStatus status) {
        for (ForgePlayer player : this.getPlayersWithStatus(status)) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }
}

