/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class ConfigString
extends ConfigValue {
    public static final String ID = "string";
    public static final Color4I COLOR = Color4I.rgb(16755273);
    private String value;
    private int charLimit;

    public ConfigString() {
        this("");
    }

    public ConfigString(String v) {
        this(v, 0);
    }

    public ConfigString(String v, int limit) {
        this.value = v;
        this.charLimit = limit;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public String getString() {
        return this.value;
    }

    public void setString(String v) {
        this.value = v;
    }

    @Override
    public Object getValue() {
        return this.getString();
    }

    @Override
    public boolean getBoolean() {
        return this.getString().equals("true");
    }

    @Override
    public int getInt() {
        return Integer.parseInt(this.getString());
    }

    @Override
    public ConfigString copy() {
        return new ConfigString(this.getString(), this.charLimit);
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public String toString() {
        return '\"' + this.getString() + '\"';
    }

    @Override
    public String getGuiText() {
        return this.getString();
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        this.setString(text);
        return true;
    }

    @Override
    public void addInfo(ConfigValueInfo info, List<String> list) {
        super.addInfo(info, list);
        if (this.charLimit > 0) {
            list.add(TextFormatting.AQUA + "Char Limit: " + this.charLimit);
        }
    }

    public void func_152753_a(JsonElement json) {
        this.setString(json.getAsString());
    }

    public JsonElement func_151003_a() {
        String s = this.getString();
        return s.isEmpty() ? JsonUtils.JSON_EMPTY_STRING : new JsonPrimitive(s);
    }

    @Override
    public void writeData(DataOut data) {
        data.writeString(this.getString());
        data.writeShort(this.charLimit);
    }

    @Override
    public void readData(DataIn data) {
        this.setString(data.readString());
        this.charLimit = data.readUnsignedShort();
    }

    public boolean isEmpty() {
        return this.getString().isEmpty();
    }
}

