/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class ConfigInt
extends ConfigValue
implements IntSupplier {
    public static final String ID = "int";
    public static final Color4I COLOR = Color4I.rgb(11164392);
    private int value;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public ConfigInt() {
    }

    public ConfigInt(int v) {
        this.value = v;
    }

    public ConfigInt(int v, int min, int max) {
        this(v);
        this.minValue = min;
        this.maxValue = max;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getInt();
    }

    public ConfigInt setMin(int v) {
        this.minValue = v;
        return this;
    }

    public ConfigInt setMax(int v) {
        this.maxValue = v;
        return this;
    }

    public int getMin() {
        return this.minValue;
    }

    public int getMax() {
        return this.maxValue;
    }

    public void setInt(int v) {
        this.value = MathHelper.func_76125_a((int)v, (int)this.getMin(), (int)this.getMax());
    }

    @Override
    public String getString() {
        return Integer.toString(this.getInt());
    }

    @Override
    public boolean getBoolean() {
        return this.getInt() != 0;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public ConfigInt copy() {
        return new ConfigInt(this.getInt(), this.getMin(), this.getMax());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getInt() == value.getInt();
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public void addInfo(ConfigValueInfo info, List<String> list) {
        super.addInfo(info, list);
        int m = this.getMin();
        if (m != Integer.MIN_VALUE) {
            list.add(TextFormatting.AQUA + "Min: " + m);
        }
        if ((m = this.getMax()) != Integer.MAX_VALUE) {
            list.add(TextFormatting.AQUA + "Max: " + m);
        }
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        if (MathUtils.canParseInt(text)) {
            if (!simulate) {
                this.setInt(Integer.parseInt(text));
            }
            return true;
        }
        return false;
    }

    public void func_152753_a(JsonElement json) {
        this.setInt(json.getAsInt());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getInt());
    }

    @Override
    public void writeData(DataOut data) {
        data.writeInt(this.getInt());
        data.writeInt(this.getMin());
        data.writeInt(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setInt(data.readInt());
        this.setMin(data.readInt());
        this.setMax(data.readInt());
    }

    @Override
    public int getAsInt() {
        return this.getInt();
    }
}

