/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftblib.lib.config.IGuiEditConfig;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public class ConfigBoolean
extends ConfigValue
implements BooleanSupplier {
    public static final List<String> VARIANTS = Arrays.asList("true", "false");
    public static final String ID = "bool";
    public static final Color4I COLOR_TRUE = Color4I.rgb(0x33AA33);
    public static final Color4I COLOR_FALSE = Color4I.rgb(13969460);
    private boolean value;

    public ConfigBoolean() {
    }

    public ConfigBoolean(boolean v) {
        this.value = v;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    public void setBoolean(boolean v) {
        this.value = v;
    }

    public final boolean toggle() {
        boolean value = !this.getBoolean();
        this.setBoolean(value);
        return value;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getBoolean();
    }

    @Override
    public String getString() {
        return this.value ? "true" : "false";
    }

    @Override
    public int getInt() {
        return this.getBoolean() ? 1 : 0;
    }

    @Override
    public ConfigBoolean copy() {
        return new ConfigBoolean(this.getBoolean());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getBoolean() == value.getBoolean();
    }

    @Override
    public Color4I getColor() {
        return this.getBoolean() ? COLOR_TRUE : COLOR_FALSE;
    }

    @Override
    public List<String> getVariants() {
        return VARIANTS;
    }

    @Override
    public void onClicked(IGuiEditConfig gui, ConfigValueInfo info, MouseButton button) {
        this.setBoolean(!this.getBoolean());
        gui.onChanged(info.id, this.func_151003_a());
    }

    public void func_152753_a(JsonElement json) {
        if (json.getAsString().equals("toggle")) {
            this.setBoolean(!this.getBoolean());
        } else {
            this.setBoolean(json.getAsBoolean());
        }
    }

    public JsonElement func_151003_a() {
        return this.getBoolean() ? JsonUtils.JSON_TRUE : JsonUtils.JSON_FALSE;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeBoolean(this.getBoolean());
    }

    @Override
    public void readData(DataIn data) {
        this.setBoolean(data.readBoolean());
    }

    @Override
    public boolean getAsBoolean() {
        return this.getBoolean();
    }
}

