/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.client.FTBLibClient;
import com.feed_the_beast.ftblib.client.SidebarButton;
import com.feed_the_beast.ftblib.client.SidebarButtonGroup;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.List;
import net.minecraft.client.resources.I18n;

public class GuiSidebarButtonConfig
extends GuiButtonListBase {
    private static final Color4I COLOR_ENABLED = Color4I.rgba(1430765377);
    private static final Color4I COLOR_UNAVAILABLE = Color4I.rgba(1426101503);
    private static final Color4I COLOR_DISABLED = Color4I.rgba(1438401090);

    public GuiSidebarButtonConfig() {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button", (Object[])new Object[0]));
    }

    @Override
    public void addButtons(Panel panel) {
        for (SidebarButtonGroup group : FTBLibClient.SIDEBAR_BUTTON_GROUPS) {
            for (SidebarButton button : group.getButtons()) {
                panel.add(new ButtonConfigSidebarButton(panel, button));
            }
        }
    }

    @Override
    public void onClosed() {
        FTBLibClient.saveSidebarButtonConfig();
    }

    private class ButtonConfigSidebarButton
    extends SimpleTextButton {
        private final SidebarButton sidebarButton;
        private String tooltip;

        public ButtonConfigSidebarButton(Panel panel, SidebarButton s) {
            super(panel, I18n.func_135052_a((String)s.getLangKey(), (Object[])new Object[0]), s.getIcon());
            this.tooltip = "";
            this.sidebarButton = s;
            if (I18n.func_188566_a((String)s.getTooltipLangKey())) {
                this.tooltip = I18n.func_135052_a((String)s.getTooltipLangKey(), (Object[])new Object[0]);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.add(this.sidebarButton.getConfig() ? I18n.func_135052_a((String)"addServer.resourcePack.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"addServer.resourcePack.disabled", (Object[])new Object[0]));
            if (!this.tooltip.isEmpty()) {
                list.add(this.tooltip);
            }
        }

        @Override
        public Icon getButtonBackground() {
            return super.getButtonBackground().combineWith((Icon)(this.sidebarButton.getConfig() ? (this.sidebarButton.isAvailable() ? COLOR_ENABLED : COLOR_UNAVAILABLE) : COLOR_DISABLED));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.sidebarButton.setConfig(!this.sidebarButton.getConfig());
        }
    }
}

