/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib;

import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftblib")
@Config(modid="ftblib", category="")
public class FTBLibConfig {
    @Config.LangKey(value="stat.generalButton")
    public static final General general = new General();
    public static final Teams teams = new Teams();
    @Config.Comment(value={"Don't set any values to true, unless you are debugging the mod."})
    public static final Debugging debugging = new Debugging();

    public static void sync() {
        ConfigManager.sync((String)"ftblib", (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ftblib")) {
            FTBLibConfig.sync();
        }
    }

    public static class Debugging {
        @Config.Comment(value={"Enables special debug commands."})
        public boolean special_commands = false;
        @Config.Comment(value={"Print more info."})
        public boolean print_more_info = false;
        @Config.Comment(value={"Print more errors."})
        public boolean print_more_errors = false;
        @Config.Comment(value={"Log incoming and outgoing network messages."})
        public boolean log_network = false;
        @Config.Comment(value={"Log player teleporting."})
        public boolean log_teleport = false;
        @Config.Comment(value={"Log config editing."})
        public boolean log_config_editing = false;
        @Config.Comment(value={"See dev-only sidebar buttons. They probably don't do anything."})
        public boolean dev_sidebar_buttons = false;
        @Config.Comment(value={"See GUI widget bounds when you hold B."})
        public boolean gui_widget_bounds = false;
        @Config.Comment(value={"Log all events that extend EventBase."})
        public boolean log_events = false;
    }

    public static class Teams {
        @Config.Comment(value={"Automatically creates a team for player on multiplayer, based on their username and with a random color."})
        public boolean autocreate_mp = false;
        @Config.Comment(value={"Automatically creates (or joins) a team on singleplayer/LAN with ID 'singleplayer'."})
        public boolean autocreate_sp = true;
        @Config.Comment(value={"Disable no team notification entirely."})
        @Config.LangKey(value="player_config.ftblib.hide_team_notification")
        public boolean hide_team_notification = false;
    }

    public static class General {
        @Config.Comment(value={"When this mode is enabled, FTBLib assumes that server clients don't have FTBLib and/or other mods installed."})
        public boolean clientless_mode = false;
        @Config.Comment(value={"This will replace /reload with FTB version of it."})
        @Config.RequiresWorldRestart
        public boolean replace_reload_command = true;
        @Config.Comment(value={"Merges player profiles, in case player logged in without internet connection/in offline mode server.", "If set to DEFAULT, it will only merge on singleplayer worlds."})
        public EnumTristate merge_offline_mode_players = EnumTristate.TRUE;
    }
}

