/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.events.RegisterAdminPanelActionsEvent;
import com.feed_the_beast.ftblib.events.RegisterConfigValueProvidersEvent;
import com.feed_the_beast.ftblib.events.RegisterContainerProvidersEvent;
import com.feed_the_beast.ftblib.events.RegisterSyncDataEvent;
import com.feed_the_beast.ftblib.events.ServerReloadEvent;
import com.feed_the_beast.ftblib.events.player.IContainerProvider;
import com.feed_the_beast.ftblib.events.team.RegisterTeamGuiActionsEvent;
import com.feed_the_beast.ftblib.lib.EventHandler;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValueProvider;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.AdminPanelAction;
import com.feed_the_beast.ftblib.lib.data.ISyncData;
import com.feed_the_beast.ftblib.lib.data.TeamAction;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class FTBLibCommon {
    private static final EnumSet<Side> DEFAULT_SIDES = EnumSet.allOf(Side.class);
    public static final Map<String, ConfigValueProvider> CONFIG_VALUE_PROVIDERS = new HashMap<String, ConfigValueProvider>();
    public static final Map<UUID, EditingConfig> TEMP_SERVER_CONFIG = new HashMap<UUID, EditingConfig>();
    public static final Map<ResourceLocation, IContainerProvider> GUI_CONTAINER_PROVIDERS = new HashMap<ResourceLocation, IContainerProvider>();
    public static final Map<String, ISyncData> SYNCED_DATA = new HashMap<String, ISyncData>();
    public static final HashSet<ResourceLocation> RELOAD_IDS = new HashSet();
    public static final Map<ResourceLocation, TeamAction> TEAM_GUI_ACTIONS = new HashMap<ResourceLocation, TeamAction>();
    public static final Map<ResourceLocation, AdminPanelAction> ADMIN_PANEL_ACTIONS = new HashMap<ResourceLocation, AdminPanelAction>();

    private void registerEventHandler(ASMDataTable.ASMData data, Side side) throws Exception {
        List sidesEnum = (List)data.getAnnotationInfo().get("value");
        EnumSet<Side> sides = DEFAULT_SIDES;
        if (sidesEnum != null) {
            sides = EnumSet.noneOf(Side.class);
            for (Object h : sidesEnum) {
                sides.add(Side.valueOf((String)h.getValue()));
            }
        }
        if (sides != DEFAULT_SIDES && !sides.contains(side)) {
            return;
        }
        List requiredMods = (List)data.getAnnotationInfo().get("requiredMods");
        if (requiredMods != null && !requiredMods.isEmpty()) {
            for (String s : requiredMods) {
                if (FTBLibCommon.isModLoaded(s.split(";"))) continue;
                return;
            }
        }
        Class<?> c = Class.forName(data.getObjectName());
        MinecraftForge.EVENT_BUS.register(c);
    }

    private static boolean isModLoaded(String[] mods) {
        for (String mod : mods) {
            if (mod.startsWith("!")) {
                if (!Loader.isModLoaded((String)mod.substring(1))) continue;
                return false;
            }
            if (!Loader.isModLoaded((String)mod)) continue;
            return true;
        }
        return false;
    }

    public void preInit(FMLPreInitializationEvent event) {
        FTBLib.LOGGER.info("Loading FTBLib, DevEnv:" + CommonUtils.DEV_ENV);
        CommonUtils.init(event.getModConfigurationDirectory());
        Side side = event.getSide();
        for (ASMDataTable.ASMData data : event.getAsmData().getAll(EventHandler.class.getName())) {
            try {
                this.registerEventHandler(data, side);
            }
            catch (Exception exception) {}
        }
        FTBLibNetHandler.init();
        new RegisterConfigValueProvidersEvent(CONFIG_VALUE_PROVIDERS::put).post();
        new RegisterContainerProvidersEvent(GUI_CONTAINER_PROVIDERS::put).post();
        new RegisterSyncDataEvent(SYNCED_DATA::put).post();
        RankConfigAPI.getHandler();
        new ServerReloadEvent.RegisterIds(RELOAD_IDS::add).post();
        new RegisterTeamGuiActionsEvent(action -> TEAM_GUI_ACTIONS.put(action.getId(), (TeamAction)action)).post();
        new RegisterAdminPanelActionsEvent(action -> ADMIN_PANEL_ACTIONS.put(action.getId(), (AdminPanelAction)action)).post();
    }

    public void postInit() {
    }

    public void handleClientMessage(MessageToClient message) {
    }

    public void spawnDust(World world, double x, double y, double z, float r, float g, float b, float a) {
    }

    public void spawnDust(World world, double x, double y, double z, Color4I col) {
        this.spawnDust(world, x, y, z, col.redf(), col.greenf(), col.bluef(), col.alphaf());
    }

    public long getWorldTime() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82737_E();
    }

    public static class EditingConfig {
        public final ConfigGroup group;
        public final IConfigCallback callback;

        public EditingConfig(ConfigGroup g, IConfigCallback c) {
            this.group = g;
            this.callback = c;
        }
    }
}

