/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import xreliquary.items.ItemToggleable;
import xreliquary.util.StackHelper;

public class InventoryHelper {
    public static void spawnItemStack(World worldIn, double x, double y, double z, @Nonnull ItemStack stack) {
        Random rnd = new Random();
        float f = rnd.nextFloat() * 0.8f + 0.1f;
        float f1 = rnd.nextFloat() * 0.8f + 0.1f;
        float f2 = rnd.nextFloat() * 0.8f + 0.1f;
        while (stack.func_190916_E() > 0) {
            int i = rnd.nextInt(21) + 10;
            if (i > stack.func_190916_E()) {
                i = stack.func_190916_E();
            }
            ItemStack stackToDrop = stack.func_77946_l();
            stackToDrop.func_190920_e(i);
            stack.func_190918_g(i);
            EntityItem entityitem = new EntityItem(worldIn, x + (double)f, y + (double)f1, z + (double)f2, stackToDrop);
            float f3 = 0.05f;
            entityitem.field_70159_w = rnd.nextGaussian() * (double)f3;
            entityitem.field_70181_x = rnd.nextGaussian() * (double)f3 + (double)0.2f;
            entityitem.field_70179_y = rnd.nextGaussian() * (double)f3;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    @Nonnull
    public static ItemStack getTargetItem(@Nonnull ItemStack self, IInventory inventory) {
        if (self.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack targetItem = ItemStack.field_190927_a;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (StackHelper.isItemAndNbtEqual(self, stack) || stack.func_77976_d() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
        }
        inventory.func_70296_d();
        return targetItem;
    }

    public static int getItemQuantity(@Nonnull ItemStack stack, IInventory inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack newStack = inventory.func_70301_a(slot);
            if (!StackHelper.isItemAndNbtEqual(stack, newStack)) continue;
            itemQuantity += newStack.func_190916_E();
        }
        return itemQuantity;
    }

    public static boolean consumeOreDictItem(String oredictName, EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b()) continue;
            ItemStack slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            for (ItemStack ore : OreDictionary.getOres((String)oredictName)) {
                int stackSize;
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)slotStack, (boolean)false) || (stackSize = slotStack.func_190916_E()) <= 0) continue;
                slotStack.func_190918_g(1);
                if (slotStack.func_190916_E() <= 0) {
                    player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean consumeItem(String itemName, int meta, boolean ignoreMeta, EntityPlayer player) {
        return InventoryHelper.consumeItem((ItemStack is) -> is.func_77973_b().getRegistryName().toString().equals(itemName) && (ignoreMeta || is.func_77960_j() == meta), player);
    }

    public static boolean consumeItem(Function<ItemStack, Boolean> itemMatches, EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            int stackSize;
            ItemStack slotStack;
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || !itemMatches.apply(slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot)).booleanValue() || (stackSize = slotStack.func_190916_E()) <= 0) continue;
            slotStack.func_190918_g(1);
            if (slotStack.func_190916_E() <= 0) {
                player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeItem(ItemStack item, EntityPlayer player) {
        return InventoryHelper.consumeItem(item, player, 0, 1);
    }

    public static boolean consumeItem(@Nonnull ItemStack item, EntityPlayer player, int minCount) {
        return InventoryHelper.consumeItem(item, player, minCount, 1);
    }

    public static boolean consumeItem(@Nonnull ItemStack itemStack, EntityPlayer player, int minCount, int countToConsume) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemStack.func_190926_b() || countToConsume <= 0) {
            return false;
        }
        int itemCount = 0;
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> slotCounts = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            ItemStack slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            if (!StackHelper.isItemAndNbtEqual(slotStack, itemStack)) continue;
            int n = slotStack.func_190916_E();
            itemCount += n;
            slotCounts.add(new AbstractMap.SimpleEntry<Integer, Integer>(slot, n));
        }
        if (itemCount - countToConsume < minCount) {
            return false;
        }
        if (itemCount >= countToConsume) {
            slotCounts.sort((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
            int countToFill = itemCount - countToConsume;
            for (Map.Entry entry : slotCounts) {
                int slot = (Integer)entry.getKey();
                if (countToFill > 0) {
                    int stackSizeToFill = Math.min(itemStack.func_77976_d(), countToFill);
                    player.field_71071_by.func_70301_a(slot).func_190920_e(stackSizeToFill);
                    countToFill -= stackSizeToFill;
                    continue;
                }
                player.field_71071_by.func_70298_a(slot, player.field_71071_by.func_70301_a(slot).func_190916_E());
            }
            return true;
        }
        return false;
    }

    public static int tryToRemoveFromInventory(@Nonnull ItemStack contents, IInventory inventory, int maxToRemove) {
        int numberRemoved = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot).func_190926_b()) continue;
            while (inventory.func_70301_a(slot).func_190916_E() > 0 && StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents) && maxToRemove > numberRemoved) {
                numberRemoved += Math.min(maxToRemove - numberRemoved, inventory.func_70301_a(slot).func_190916_E());
                inventory.func_70298_a(slot, Math.min(maxToRemove, inventory.func_70301_a(slot).func_190916_E()));
            }
            if (numberRemoved < maxToRemove) continue;
            return numberRemoved;
        }
        return numberRemoved;
    }

    public static int tryToAddToInventory(@Nonnull ItemStack contents, IInventory inventory, int maxToAdd) {
        return InventoryHelper.tryToAddToInventory(contents, inventory, maxToAdd, EnumFacing.UP);
    }

    public static int tryToAddToInventory(@Nonnull ItemStack contents, IInventory inventory, int maxToAdd, EnumFacing insertDirection) {
        int numberAdded = 0;
        if (inventory instanceof ISidedInventory) {
            int[] slotsForFace;
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            for (int slot : slotsForFace = sidedInventory.func_180463_a(insertDirection)) {
                if (sidedInventory.func_70301_a(slot).func_190926_b() && sidedInventory.func_180462_a(slot, contents, insertDirection)) {
                    numberAdded += InventoryHelper.insertIntoEmptySlot(contents, sidedInventory, slot, maxToAdd - numberAdded);
                } else if (StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents)) {
                    if (inventory.func_70301_a(slot).func_190916_E() == Math.min(inventory.func_70301_a(slot).func_77976_d(), inventory.func_70297_j_())) continue;
                    int stackAddition = InventoryHelper.addToNonEmptySlot(inventory, maxToAdd - numberAdded, slot);
                    numberAdded += stackAddition;
                }
                if (numberAdded < maxToAdd) {
                    continue;
                }
                break;
            }
        } else {
            int inventorySize = inventory instanceof InventoryPlayer ? ((InventoryPlayer)inventory).field_70462_a.size() : inventory.func_70302_i_();
            for (int slot = 0; slot < inventorySize; ++slot) {
                if (inventory.func_70301_a(slot).func_190926_b() && inventory.func_94041_b(slot, contents)) {
                    numberAdded += InventoryHelper.insertIntoEmptySlot(contents, inventory, slot, maxToAdd - numberAdded);
                } else if (StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents)) {
                    if (inventory.func_70301_a(slot).func_190916_E() == Math.min(inventory.func_70301_a(slot).func_77976_d(), inventory.func_70297_j_())) continue;
                    int stackAddition = InventoryHelper.addToNonEmptySlot(inventory, maxToAdd - numberAdded, slot);
                    numberAdded += stackAddition;
                }
                if (numberAdded < maxToAdd) {
                    continue;
                }
                break;
            }
        }
        if (numberAdded > 0) {
            inventory.func_70296_d();
        }
        return numberAdded;
    }

    private static int addToNonEmptySlot(IInventory inventory, int maxToAdd, int slot) {
        ItemStack slotStack = inventory.func_70301_a(slot);
        int stackAddition = Math.min(Math.min(slotStack.func_77976_d(), inventory.func_70297_j_()) - slotStack.func_190916_E(), maxToAdd);
        slotStack.func_190917_f(stackAddition);
        return stackAddition;
    }

    private static int insertIntoEmptySlot(@Nonnull ItemStack contents, IInventory inventory, int slot, int maxToAdd) {
        int numberAdded;
        int stackAddition;
        for (numberAdded = 0; inventory.func_70301_a(slot).func_190926_b() && maxToAdd > numberAdded; numberAdded += stackAddition) {
            stackAddition = Math.min(Math.min(contents.func_77976_d(), inventory.func_70297_j_()), maxToAdd - numberAdded);
            ItemStack newContents = contents.func_77946_l();
            newContents.func_190920_e(stackAddition);
            inventory.func_70299_a(slot, newContents);
        }
        return numberAdded;
    }

    private static int insertIntoEmptySlot(@Nonnull ItemStack contents, ISidedInventory inventory, int slot, int maxToAdd) {
        int numberAdded;
        int stackAddition;
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        for (numberAdded = 0; (stackInSlot.func_190926_b() || stackInSlot.func_190916_E() < stackInSlot.func_77976_d()) && maxToAdd > numberAdded; numberAdded += stackAddition) {
            int maxSlotAddition = stackInSlot.func_190926_b() ? contents.func_77976_d() : stackInSlot.func_77976_d() - stackInSlot.func_190916_E();
            stackAddition = Math.min(maxSlotAddition, maxToAdd - numberAdded);
            ItemStack newContents = contents.func_77946_l();
            newContents.func_190920_e(stackAddition);
            inventory.func_70299_a(slot, newContents);
            stackInSlot = inventory.func_70301_a(slot);
        }
        return numberAdded;
    }

    public static void tryRemovingLastStack(IInventory inventory, World world, BlockPos pos) {
        for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            inventory.func_70299_a(i, ItemStack.field_190927_a);
            if (world.field_72995_K) {
                return;
            }
            inventory.func_70296_d();
            EntityItem itemEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, stack);
            world.func_72838_d((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(EntityPlayer player, IInventory inventory, EnumHand hand) {
        if (!inventory.func_70301_a(0).func_190926_b()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand).func_77946_l();
        stack.func_190920_e(1);
        inventory.func_70299_a(0, stack);
        player.func_184586_b(hand).func_190918_g(1);
        if (player.func_184586_b(hand).func_190916_E() == 0) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        player.field_71071_by.func_70296_d();
        return true;
    }

    public static boolean playerHasItem(EntityPlayer player, Item item) {
        return InventoryHelper.playerHasItem(player, item, false);
    }

    public static boolean playerHasItem(EntityPlayer player, Item item, boolean checkEnabled) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            if (checkEnabled && stack.func_77973_b() instanceof ItemToggleable) {
                return ((ItemToggleable)stack.func_77973_b()).isEnabled(stack);
            }
            return true;
        }
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.getSlots(); ++i) {
                ItemStack baubleStack = inventoryBaubles.getStackInSlot(i);
                if (baubleStack.func_190926_b() || baubleStack.func_77973_b() != item) continue;
                if (checkEnabled && baubleStack.func_77973_b() instanceof ItemToggleable) {
                    return ((ItemToggleable)baubleStack.func_77973_b()).isEnabled(baubleStack);
                }
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static ItemStack getCorrectItemFromEitherHand(EntityPlayer player, Item item) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        EnumHand itemInHand = InventoryHelper.getHandHoldingCorrectItem(player, item);
        if (itemInHand == null) {
            return ItemStack.field_190927_a;
        }
        return player.func_184586_b(itemInHand);
    }

    private static EnumHand getHandHoldingCorrectItem(EntityPlayer player, Item item) {
        if (player.func_184614_ca().func_77973_b() == item) {
            return EnumHand.MAIN_HAND;
        }
        if (player.func_184592_cb().func_77973_b() == item) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static void addItemToPlayerInventory(EntityPlayer player, ItemStack ist) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            player.field_71071_by.func_70299_a(i, ist);
            return;
        }
        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, ist));
    }
}

