/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.init.ModItems;
import xreliquary.items.ItemSojournerStaff;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;

public class ItemLanternOfParanoia
extends ItemToggleable {
    private static final Map<String, Block> TORCH_BLOCKS = new HashMap<String, Block>();

    public ItemLanternOfParanoia() {
        super("lantern_of_paranoia");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public int getRange() {
        return Settings.Items.LanternOfParanoia.placementScanRadius;
    }

    public void func_77663_a(ItemStack stack, World world, Entity e, int i, boolean f) {
        if (!this.isEnabled(stack)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            block0: for (int xDiff = -this.getRange(); xDiff <= this.getRange(); ++xDiff) {
                for (int zDiff = -this.getRange(); zDiff <= this.getRange(); ++zDiff) {
                    for (int yDiff = this.getRange() / 2; yDiff >= -this.getRange() / 2; --yDiff) {
                        int lightLevel;
                        int x = playerX + xDiff;
                        int y = playerY + yDiff;
                        int z = playerZ + zDiff;
                        if (player.field_70170_p.func_175623_d(new BlockPos(x, y, z)) && (lightLevel = player.field_70170_p.func_175671_l(new BlockPos(x, y, z))) <= Settings.Items.LanternOfParanoia.minLightLevel && this.tryToPlaceTorchAround(stack, x, y, z, player, world)) break block0;
                    }
                }
            }
        }
    }

    private boolean findAndDrainSojournersStaff(EntityPlayer player, Block torch) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            if (player.field_71071_by.func_70301_a(slot).func_77973_b() != ModItems.sojournerStaff || !ItemSojournerStaff.removeItemFromInternalStorage(player.field_71071_by.func_70301_a(slot), torch.getRegistryName().toString(), 1, player)) continue;
            return true;
        }
        return false;
    }

    private Block getTorchBlock(String registryName) {
        if (!TORCH_BLOCKS.containsKey(registryName)) {
            TORCH_BLOCKS.put(registryName, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName)));
        }
        return TORCH_BLOCKS.get(registryName);
    }

    private boolean tryToPlaceTorchAround(@Nonnull ItemStack stack, int xO, int yO, int zO, EntityPlayer player, World world) {
        double playerEyeHeight = player.field_70163_u + (double)player.func_70047_e();
        for (float xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    IBlockState blockState;
                    Vec3d playerVec = new Vec3d(player.field_70165_t + (double)xOff, playerEyeHeight + (double)yOff, player.field_70161_v + (double)zOff);
                    Vec3d rayTraceVector = new Vec3d((double)xO + 0.5 + (double)xOff, (double)yO + 0.5 + (double)yOff, (double)zO + 0.5 + (double)zOff);
                    RayTraceResult rayTraceResult = world.func_147447_a(playerVec, rayTraceVector, false, false, true);
                    if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK || !(blockState = world.func_180495_p(rayTraceResult.func_178782_a())).func_177230_c().func_176209_a(blockState, false)) continue;
                    return false;
                }
            }
        }
        for (String torchRegistryName : Settings.Items.SojournerStaff.torches) {
            Block torch = this.getTorchBlock(torchRegistryName);
            if (!torch.func_176196_c(world, new BlockPos(xO, yO, zO))) continue;
            ArrayList trySides = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST});
            ItemStack torchStack = new ItemStack(torch);
            for (EnumFacing side : trySides) {
                IBlockState torchBlockState;
                if (!world.func_190527_a(torch, new BlockPos(xO, yO, zO), false, side, (Entity)player) || !InventoryHelper.consumeItem(torchStack, player, 0, 1) && !this.findAndDrainSojournersStaff(player, torch) || !this.placeBlockAt(stack, player, world, new BlockPos(xO, yO, zO), torchBlockState = this.getTorchSideAttempt(world, torch, new BlockPos(xO, yO, zO), side, player))) continue;
                torch.func_176213_c(world, new BlockPos(xO, yO, zO), torchBlockState);
                double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)xO + 0.5, (double)yO + 0.5, (double)zO + 0.5, gauss, gauss, 0.0, new int[0]);
                SoundType torchSoundType = torch.getSoundType(torchBlockState, world, new BlockPos(xO, yO, zO), null);
                world.func_184133_a(null, new BlockPos(xO, yO, zO), torchSoundType.func_185844_d(), SoundCategory.BLOCKS, (torchSoundType.func_185843_a() + 1.0f) / 2.0f, torchSoundType.func_185847_b() * 0.8f);
                return true;
            }
        }
        return false;
    }

    private IBlockState getTorchSideAttempt(World world, Block torch, BlockPos pos, EnumFacing side, EntityPlayer player) {
        return torch.getStateForPlacement(world, pos, side, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), 0, (EntityLivingBase)player, EnumHand.MAIN_HAND);
    }

    private boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState torchBlockState) {
        if (!world.func_180501_a(pos, torchBlockState, 3)) {
            return false;
        }
        if (torchBlockState.func_177230_c() == torchBlockState.func_177230_c()) {
            torchBlockState.func_177230_c().func_189540_a(torchBlockState, world, pos, torchBlockState.func_177230_c(), pos);
            torchBlockState.func_177230_c().func_180633_a(world, pos, torchBlockState, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

