/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import xreliquary.blocks.BlockBase;
import xreliquary.reference.Settings;

public class BlockFertileLilypad
extends BlockBush {
    private static final AxisAlignedBB LILY_PAD_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Water;
    }

    public BlockFertileLilypad() {
        this.func_149675_a(false);
        BlockBase.init((Block)this, "fertile_lilypad");
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random par5Random) {
        this.growCropsNearby(world, pos, state);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)pos.func_177958_n() + 0.5 + rand.nextGaussian() / 8.0, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5 + rand.nextGaussian() / 8.0, 0.0, 0.9, 0.5, new int[0]);
    }

    private int secondsBetweenGrowthTicks() {
        return Settings.Blocks.FertileLilypad.secondsBetweenGrowthTicks;
    }

    private int tileRange() {
        return Settings.Blocks.FertileLilypad.tileRange;
    }

    private int fullPotencyRange() {
        return Settings.Blocks.FertileLilypad.fullPotencyRange;
    }

    private void growCropsNearby(World world, BlockPos pos, IBlockState state) {
        int xO = pos.func_177958_n();
        int yO = pos.func_177956_o();
        int zO = pos.func_177952_p();
        for (int xD = -this.tileRange(); xD <= this.tileRange(); ++xD) {
            for (int yD = -1; yD <= this.tileRange(); ++yD) {
                for (int zD = -this.tileRange(); zD <= this.tileRange(); ++zD) {
                    int x = xO + xD;
                    int y = yO + yD;
                    int z = zO + zD;
                    double distance = Math.sqrt(Math.pow(x - xO, 2.0) + Math.pow(y - yO, 2.0) + Math.pow(z - zO, 2.0));
                    distance -= (double)this.fullPotencyRange();
                    distance = Math.min(1.0, distance);
                    double distanceCoefficient = 1.0 - distance / (double)this.tileRange();
                    IBlockState cropState = world.func_180495_p(new BlockPos(x, y, z));
                    Block cropBlock = cropState.func_177230_c();
                    if (!(cropBlock instanceof IPlantable) && !(cropBlock instanceof IGrowable) || cropBlock instanceof BlockFertileLilypad) continue;
                    world.func_180497_b(new BlockPos(x, y, z), cropBlock, (int)(distanceCoefficient * (double)this.secondsBetweenGrowthTicks() * 20.0), 1);
                    cropBlock.func_180650_b(world, new BlockPos(x, y, z), cropState, world.field_73012_v);
                }
            }
        }
        world.func_180497_b(pos, state.func_177230_c(), this.secondsBetweenGrowthTicks() * 20, 1);
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB mask, @Nonnull List<AxisAlignedBB> list, Entity collidingEntity, boolean p_185477_7_) {
        if (!(collidingEntity instanceof EntityBoat)) {
            BlockFertileLilypad.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)LILY_PAD_AABB);
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150355_j;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState blockBelowState = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && blockBelowState.func_185904_a() == Material.field_151586_h && (Integer)blockBelowState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return LILY_PAD_AABB;
    }
}

