/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Sets;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.integrateddynamics.block.BlockSqueezer;

public class TileSqueezer
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private int itemHeight = 1;
    private SingleCache<ItemStack, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent>> recipeCache;

    public TileSqueezer() {
        super(1, "squeezerInventory", 1, 1000, "squeezerTank");
        this.addSlotsToSide(EnumFacing.UP, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.DOWN, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.NORTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.SOUTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.WEST, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.EAST, Sets.newHashSet((Object[])new Integer[]{0}));
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ItemStack, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent>>(){

            public IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> getNewValue(ItemStack key) {
                IngredientRecipeComponent recipeInput = new IngredientRecipeComponent(key);
                return TileSqueezer.this.getRegistry().findRecipeByInput((IRecipeInput)recipeInput);
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.func_77989_b((ItemStack)cacheKey, (ItemStack)newKey);
            }
        });
    }

    protected IRecipeRegistry<BlockSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> getRegistry() {
        return BlockSqueezer.getInstance().getRecipeRegistry();
    }

    public IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> getCurrentRecipe() {
        return (IRecipe)this.recipeCache.get((Object)this.func_70301_a(0).func_77946_l());
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K) {
            if (!this.getTank().isEmpty()) {
                EnumFacing[] sides;
                for (EnumFacing side : sides = ((BlockSqueezer.EnumAxis)((Object)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockSqueezer.AXIS))).getSides()) {
                    FluidStack fluidStack;
                    IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), (EnumFacing)side.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                    if (this.getTank().isEmpty() || handler == null || handler.fill(fluidStack = new FluidStack(this.getTank().getFluid(), Math.min(100, this.getTank().getFluidAmount())), false) <= 0) continue;
                    int filled = handler.fill(fluidStack, true);
                    this.drain(filled, true);
                }
            } else if (this.itemHeight == 7 && this.getCurrentRecipe() != null) {
                IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe = this.getCurrentRecipe();
                this.func_70299_a(0, ItemStack.field_190927_a);
                for (IngredientRecipeComponent recipeComponent : ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getSubIngredientComponents()) {
                    if (recipeComponent.getChance() != 1.0f && !(recipeComponent.getChance() >= this.func_145831_w().field_73012_v.nextFloat())) continue;
                    ItemStack resultStack = recipeComponent.getFirstItemStack().func_77946_l();
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        IItemHandler itemHandler;
                        if (resultStack.func_190926_b() || side == EnumFacing.UP || (itemHandler = (IItemHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), (EnumFacing)side.func_176734_d(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) == null) continue;
                        resultStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)resultStack, (boolean)false);
                    }
                    if (resultStack.func_190926_b()) continue;
                    ItemStackHelpers.spawnItemStack((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)resultStack);
                }
                if (((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack() != null) {
                    this.fill(((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack(), true);
                }
            }
        }
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return (Integer)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockSqueezer.HEIGHT) == 1 && this.func_70301_a(0).func_190926_b() && super.func_180462_a(slot, itemStack, side);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        super.func_70299_a(slotId, itemstack);
        this.itemHeight = 1;
        this.sendUpdate();
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.sendUpdate();
        this.updateInventoryHash();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

