/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezerConfig;
import org.cyclops.integrateddynamics.core.tileentity.TileMechanicalMachine;

public class TileMechanicalSqueezer
extends TileMechanicalMachine<ItemStack, BlockMechanicalSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties> {
    private static final int SLOTS = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private static final int TANK_SIZE = 100000;
    @NBTPersist
    private boolean autoEjectFluids = false;
    private final SingleUseTank tank = new SingleUseTank(100000, (TileEntity)this);

    public TileMechanicalSqueezer() {
        super(5);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.tank);
    }

    @Override
    protected SingleCache.ICacheUpdater<ItemStack, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<ItemStack, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties>>(){

            public IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties> getNewValue(ItemStack key) {
                IngredientRecipeComponent recipeInput = new IngredientRecipeComponent(key);
                return TileMechanicalSqueezer.this.getRecipeRegistry().findRecipeByInput((IRecipeInput)recipeInput);
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.func_77989_b((ItemStack)cacheKey, (ItemStack)newKey);
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockMechanicalSqueezer.ON);
    }

    @Override
    public void setWorking(boolean working) {
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockMechanicalSqueezer.ON, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.getTank().readFromNBT(tag.func_74775_l("tank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("tank", (NBTBase)this.getTank().writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(tag);
    }

    @Override
    protected IRecipeRegistry<BlockMechanicalSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties> getRecipeRegistry() {
        return BlockMechanicalSqueezer.getInstance().getRecipeRegistry();
    }

    @Override
    protected ItemStack getCurrentRecipeCacheKey() {
        return this.func_70301_a(0).func_77946_l();
    }

    @Override
    public IngredientRecipeComponent getRecipeInput(NonNullList<ItemStack> inputStacks) {
        return new IngredientRecipeComponent((ItemStack)inputStacks.get(0));
    }

    @Override
    public int getRecipeDuration(IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties> recipe) {
        return ((DurationRecipeProperties)recipe.getProperties()).getDuration();
    }

    @Override
    protected boolean finalizeRecipe(IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DurationRecipeProperties> recipe, boolean simulate) {
        NonNullList outputStacks = NonNullList.func_191196_a();
        for (IngredientRecipeComponent recipeComponent : ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getSubIngredientComponents()) {
            ItemStack outputStack = recipeComponent.getFirstItemStack().func_77946_l();
            if (outputStack.func_190926_b() || !simulate && recipeComponent.getChance() != 1.0f && !(recipeComponent.getChance() >= this.func_145831_w().field_73012_v.nextFloat())) continue;
            InventoryHelpers.addStackToList((NonNullList)outputStacks, (ItemStack)outputStack);
        }
        if (!InventoryHelpers.addToInventory((IInventory)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)outputStacks, (boolean)simulate).isEmpty()) {
            return false;
        }
        FluidStack outputFluid = ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack();
        if (outputFluid != null && this.getTank().fill(outputFluid.copy(), !simulate) != outputFluid.amount) {
            return false;
        }
        if (!simulate) {
            this.func_70298_a(0, 1);
        }
        return true;
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalSqueezerConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalSqueezerConfig.capacity;
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.field_72995_K && this.isAutoEjectFluids() && !this.getTank().isEmpty()) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), (EnumFacing)side.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                if (handler == null) continue;
                FluidStack fluidStack = this.getTank().getFluid().copy();
                fluidStack.amount = Math.min(BlockMechanicalSqueezerConfig.autoEjectFluidRate, fluidStack.amount);
                if (handler.fill(fluidStack, false) <= 0) continue;
                this.getTank().drain(handler.fill(fluidStack, true), true);
                break;
            }
        }
    }

    public boolean isAutoEjectFluids() {
        return this.autoEjectFluids;
    }

    public void setAutoEjectFluids(boolean autoEjectFluids) {
        this.autoEjectFluids = autoEjectFluids;
        this.sendUpdate();
    }
}

